<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\Wallet;
use App\Models\Cashback;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CashbackToWallet extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cashback:to-wallet';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Transfer cashback with today\'s expiry date to wallet table';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */

    public function handle()
    {
        $today = Carbon::today()->toDateString();
        $expiryDate = Carbon::today()->addMonth()->toDateString();

        // Get expired cashback records
        $cashbacks = Cashback::where('expiry_date', $today)->get();

        if ($cashbacks->isEmpty()) {
            $this->info('No cashback records to transfer.');
            return;
        }

        try {
            DB::transaction(function () use ($cashbacks, $expiryDate, $today) {
                // Process in batches
                foreach ($cashbacks->chunk(100) as $chunk) {
                    foreach ($chunk as $cashback) {
                        Wallet::updateOrCreate(
                            [
                                'customer_id' => $cashback->customer_id,
                                'booking_id'  => $cashback->booking_id,
                            ],
                            [
                                'balance'     => $cashback->cashback_amount,
                                'type'        => 'credit',
                                'expiry_date' => $expiryDate,
                                'status'      => 'active',
                            ]
                        );
                    }
                }

                
            });

            $this->info('Cashback successfully transferred to wallets.');
        } catch (\Exception $e) {
            // Transaction automatically rolls back if exception is thrown
            $this->error('Failed to transfer cashback: ' . $e->getMessage());
        }
    }
}
