<?php
/**
 * @package     Base
 * @subpackage  Base
 * @Author      Amar Technolabs Pvt. ltd(info@amarinfotech.com)
 * @Copyright(C) 2023 [NAME OF THE ORGANISATION THAT ON BEHALF OF THE CODE WE ARE WORKING].
 * @Version 1.0.0
 * module of the Base.
 */
namespace App\Http\Controllers\API\V1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class BaseController extends Controller
{
    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function sendResponse($result, $message, $success = true)
    {
        $response = [
            'success' => (bool)$success,
            'data' => $result,
            'message' => $message,
        ];
    
        
    
        return response()->json($response, 200);
    }


    /**
     * return error response.
     *
     * @return \Illuminate\Http\Response
     */
    public function sendError($error, $errorMessages = [], $code = 500)
    {
        if (!is_int($code)) {
            
            $code = 500; // Default to 500
        }
    
        $response = [
            'success' => false,
            'message' => $error,
            'data' => !empty($errorMessages) ? $errorMessages : [],
        ];
    
        
    
        return response()->json($response, $code);
    }
}
