<?php

namespace App\Http\Controllers\API\V1;

use App\Models\ContactUs;
use App\Traits\EmailService;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class ContactUsController extends BaseController
{
    //
   
    use EmailService;
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email',
            'phone_code' => 'required', 
            'phone' => 'required',
            'message' => 'required',
        ]);

        if ($validator->fails()) {
            $this->sendError('Invalid request',[$validator->errors()],200);
        }

        $contactUs = ContactUs::create($request->all());

        $userData = [
            'UserName'=>$request->name,
            'Email'=>$request->email,
            'PhoneCode'=>$request->phone_code,
            'Phone'=>$request->phone,
            'Message'=>$request->message
        ];

        $code = 'CONTACT_US_EMAIL';
        $getTemplateData = $this->contactUsMailTemplate($code, $userData);
       
        $subject = $getTemplateData['data']['subject'];
        $mailData = $getTemplateData['data']['mailData'];

        $files = [];

        $this->sendEmail($request->email, $subject, $mailData, $files, $getTemplateData['agencyName']);
        
        $this->sendResponse('Your message has been successfully submitted',[$contactUs],200);
    }
}
