<?php

namespace App\Http\Controllers\API\V1;

use App\Models\Subscribe;
use App\Traits\EmailService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\API\V1\BaseController as BaseController;
use App\Models\SubscribeLog;
use GrahamCampbell\ResultType\Success;

class SubscribeController extends  BaseController
{
    use EmailService;
    public function addEmail(Request $request)
{
    try {
      
        $validator = Validator::make($request->all(), [
            'email' => 'required|email'
        ]);

        if ($validator->fails()) {
            return $this->sendError('The "email" field is required and must be a valid email.', [], 400);
        }

        
        $existingSubscriber = Subscribe::where('email', $request->email)->first();
        if ($existingSubscriber) {
           
            SubscribeLog::create([
                'subscriber_id' => $existingSubscriber->id,
                'purpose' => 'Duplicate Entry'
            ]);

            return $this->sendError('Email already exists.', [], 400);
        }

        
        $newSubscriber = Subscribe::create([
            'email' => $request->email
        ]);

        if ($newSubscriber) {
           
            SubscribeLog::create([
                'subscriber_id' => $newSubscriber->id,
                'purpose' => 'New Entry'
            ]);

            
            $email = $request->email;
            $code = 'SUBSCRIBE_MAIL';
            $getTemplateData = $this->subscribeMailTemplate($code);
            $subject = $getTemplateData['data']['subject'];
            $mailData = $getTemplateData['data']['mailData'];
           
            $files = [];
    
    
            $this->sendEmail($email, $subject, $mailData, $files, $getTemplateData['agencyName']);

            return $this->sendResponse($newSubscriber, 'Subscriber added successfully.', true, 200);
        }

        return $this->sendError('Failed to create subscriber.', [], 500);

    } catch (\Throwable $e) {
        return $this->sendError('Something went wrong.', ['error' => $e->getMessage()], 500);
    }
}

    
}
