<?php

/**
 * @package     Customers
 * @subpackage  Customer
 * @Author      Amar Technolabs Pvt. ltd(info@amarinfotech.com)
 * @Copyright(C) 2023 [NAME OF THE ORGANISATION THAT ON BEHALF OF THE CODE WE ARE WORKING].
 * @Version 1.0.0
 * module of the Customers.
 */

namespace App\Http\Controllers\API\V1;

use App\Http\Controllers\API\V1\BaseController as BaseController;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\CustomerTraveller;
use App\Models\Setting;
use App\Models\Country;

class TravellerController extends BaseController
{

    /**
     * @OA\Get(
     *   path="/v1/customer/get-traveller-list",
     *   security={
     *     {"bearerAuth": {}}
     *   },
     *   tags={"Customer"},
     *   summary="Get Traveller List",
     *   description="get Traveller List",
     *   operationId="getTraveller",

     *   @OA\Response(
     *      response=200,
     *       description="Success",
     *      @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *   ),
     *   @OA\Response(
     *      response=401,
     *       description="Unauthenticated"
     *   ),
     *   @OA\Response(
     *      response=400,
     *      description="Bad Request"
     *   ),
     *   @OA\Response(
     *      response=404,
     *      description="not found"
     *   ),
     *      @OA\Response(
     *          response=403,
     *          description="Forbidden"
     *      )
     * )
     * )
     * get driver status
     *
     * @return \Illuminate\Http\Response
     */
    public function getTraveller(Request $request)
    {
        try {

            $perPage = Setting::where('config_key', 'general|setting|pagePerAPIRecords')->value('value');
            $filter = array(
                'customer_id' => Auth::id(),
                'per_page' => $perPage,
            );
            $travellerDataList = CustomerTraveller::getTravellerData($filter);
            $travellerData = $travellerDataList['data'];
            foreach ($travellerData as $index => $traveller) {
                $traveller['nationalIdExpireDate'] = $traveller['national_id_expiry_date'];
                $traveller['date_birth'] = $traveller['national_id_date_of_birth'] ?? '';

                unset($traveller['national_id_expiry_date']);
                unset($traveller['national_id_date_of_birth']);

                
                $travellerData[$index] = $traveller;
            }
            // echo "<pre>";print_r($travellerDataList['data'][0]);die;
            if ($travellerDataList['status']) {
                $success = true;
                return $this->sendResponse($travellerData, 'Traveller Listed Successfully!', $success);
            } else {
                $success = [];
                return $this->sendError(no_record_found, $success, 200);
            }
        } catch (Exception $e) {
            $success = [];
            return $this->sendError($success, 'Something went wrong', ['error' => $e], 500);
        }
    }

    /**
     * @OA\Post(
     *   path="/v1/customer/create-traveller",
     *   security={
     *     {"bearerAuth": {}}
     *   },
     *   tags={"Customer"},
     *   summary="Create Traveller",
     *   description="Send request for Create Traveller",
     *   operationId="createTraveller",
     *   @OA\RequestBody(
     *     required=true,
     *     description="Create Traveller",
     *     @OA\MediaType(
     *       mediaType="multipart/form-data",
     *       @OA\Schema(
     *           required={"title","first_name","last_name","date_of_birth","gender","nationality","id_type","id_number","issue_date","expiry_date","issue_country"},
     *           @OA\Property(property="language_code", type="string",description="pass language_code either 'en' or 'ar'", default="en" ),
     *           @OA\Property(property="title", type="string",description="pass title either 'mr','mrs' or 'miss'", default="" ),
     *           @OA\Property(property="first_name", type="string",description="need to pass a first name", default="" ),
     *           @OA\Property(property="second_name", type="string",description="pass a second name", default="" ),
     *           @OA\Property(property="last_name", type="string",description="need to pass last name", default="" ),
     *           @OA\Property(property="date_of_birth", type="string",description="need to pass date of birth in Y-m-d format", default="" ),
     *           @OA\Property(property="gender", type="string",description="need to pass gender either 'male' or 'female'", default="" ),
     *           @OA\Property(property="nationality", type="string",description="need to pass iso_code that fetch by call API 'get-countries'", default="" ),
     *           @OA\Property(property="id_type", type="string",description="need to pass id type either 'passport' or 'national_id'", default="" ),
     *           @OA\Property(property="id_number", type="integer",description="need to pass id number as passed id type", default="" ),
     *           @OA\Property(property="issue_date", type="string",description="need to pass issue date in Y-m-d format", default="" ),
     *           @OA\Property(property="expiry_date", type="string",description="need to pass expiry date in Y-m-d format", default="" ),
     *           @OA\Property(property="issue_country", type="string",description="need to pass iso_code that fetch by call API 'get-countries'", default="" ),
     *           @OA\Property(property="status", type="string",description="pass status either 'active' or 'inactive'", default="" ),
     *           @OA\Property(property="upload_document", type="string", format="binary",description="select document image *ensure that you are uploading an image is 2MB or less and one of the following types: JPG,JPEG, or PNG"),
     *           )
     *     ),
     *   ),
     *   @OA\Response(
     *      response=200,
     *       description="Success",
     *      @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *   ),
     *   @OA\Response(
     *      response=401,
     *       description="Unauthenticated"
     *   ),
     *   @OA\Response(
     *      response=400,
     *      description="Bad Request"
     *   ),
     *   @OA\Response(
     *      response=404,
     *      description="not found"
     *   ),
     *      @OA\Response(
     *          response=403,
     *          description="Forbidden"
     *      )
     * )
     * */
    public function createTraveller(Request $request)
    {
        $return = array(
            'status' => 0,
            'data' => [],
            'message' => 'Something went wrong'
        );
        try {
            // $validator = Validator::make($request->all(), [
            //     'language_code' => 'nullable|in:en,ar',
            //     'first_name' => 'required',
            //     'last_name' => 'required',
            //     'date_of_birth' => 'required|date_format:Y-m-d|before:today',
            //     'status' => 'nullable|in:active,inactive',
            //     'upload_document' => 'nullable|mimes:jpeg,jpg,png|max:2048',

            // ]);
            // if ($validator->fails()) {
            //     return response()->json(['status' => false, 'message' => $validator->errors()->first(), 'data' => [$validator->errors()]], 200);
            // }
            //validation foe iso code
            // $nationalityId = Country::select('id')->where('id', request()->input('nationality'))->where('status', 'active')->value('id');

            // if (request()->input('nationality') != $nationalityId) {
            //     $success = [];
            //     return $this->sendError('Please Enter Valid nationality', $success, 400);
            // }
            // $countryId = Country::select('id')->where('id', request()->input('issue_country'))->where('status', 'active')->value('id');
            // if (request()->input('issue_country') != $countryId) {
            //     $success = [];
            //     return $this->sendError('Please Enter Valid issue country', $success, 400);
            // }
           $travellerData = $request->all();

            $requestData = array(
                'booking_id' => '',
                'title' => $travellerData['title'] ?? '',
                'first_name' => $travellerData['first_name'] ?? '',
                'second_name' => isset($travellerData['second_name']) ? $travellerData['second_name'] : '',
                'last_name' => $travellerData['last_name'] ?? '',
                'date_of_birth' => $travellerData['date_of_birth'],
                'issue_date' => $travellerData['issue_date'] ?? '',
                'expire_date' => $travellerData['expire_date'] ?? '',
                'status' => $travellerData['status'] ?? '',
                'document' => isset($travellerData['upload_document']) ? $travellerData['upload_document'] : '',

                'relationship' => isset($travellerData['relationship']) ? $travellerData['relationship'] : '',
                'email' => isset($travellerData['email']) ? $travellerData['email'] : '',
                'phone' => isset($travellerData['phone']) ? $travellerData['phone'] : '',
                'address' => isset($travellerData['address']) ? $travellerData['address'] : '',
                'passport_number' => isset($travellerData['passport_number']) ? $travellerData['passport_number'] : '',
                'passport_nationality' => isset($travellerData['passport_nationality']) ? $travellerData['passport_nationality'] : '',
                'passport_issued_country' => isset($travellerData['passport_issued_country']) ? $travellerData['passport_issued_country'] : '',
                'national_id' => isset($travellerData['national_id']) ? $travellerData['national_id'] : '',
                'national_id_nationality' => isset($travellerData['national_id_nationality']) ? $travellerData['national_id_nationality'] : '',
                'national_id_issued_country' => isset($travellerData['national_id_issued_country']) ? $travellerData['national_id_issued_country'] : '',
                'iqama_id' => isset($travellerData['iqama_id']) ? $travellerData['iqama_id'] : '',
                'iqama_id_nationality' => isset($travellerData['iqama_id_nationality']) ? $travellerData['iqama_id_nationality'] : '',
                'iqama_id_expire_date' => isset($travellerData['iqama_id_expire_date']) ? $travellerData['iqama_id_expire_date'] : '',
                'frequently_flyer_airline_name' => isset($travellerData['frequently_flyer_airline_name']) ? $travellerData['frequently_flyer_airline_name'] : '',
                'frequently_flyer_programme' => isset($travellerData['frequently_flyer_programme']) ? $travellerData['frequently_flyer_programme'] : '',
                'frequently_flyer_number' => isset($travellerData['frequently_flyer_number']) ? $travellerData['frequently_flyer_number'] : '',
                'national_id_expiry_date' => $travellerData['nationalIdExpireDate'] ?? '',
                'national_id_date_of_birth' => $travellerData['date_birth'] ?? '',
            );
            $requestData['customer_id'] = Auth::id();

            $response = CustomerTraveller::createTravellers($requestData);
            if ($response) {
                $success = true;
                $response['data']->nationalIdExpireDate = $response['data']->national_id_expiry_date;
                $response['data']->date_birth = $response['data']->national_id_date_of_birth;
                unset($response['data']->national_id_expiry_date);
                unset($response['data']->national_id_date_of_birth);
                return $this->sendResponse($response, 'Traveller Saved Successfully!', $success);
            } else {
                $success = [];
                return $this->sendError('Traveller Not Saved', $success, 200);
            }
        } catch (\Exception $e) {
            return $this->sendError('Something went wrong', ['error' => $e], 500);
        }
    }

    /**
     * @OA\Post(
     *   path="/v1/customer/update-traveller",
     *   security={
     *     {"bearerAuth": {}}
     *   },
     *   tags={"Customer"},
     *   summary="Update Traveller",
     *   description="Send request for Update Traveller",
     *   operationId="updateTraveller",
     *   @OA\RequestBody(
     *     required=true,
     *     description="Update Traveller",
     *     @OA\MediaType(
     *       mediaType="multipart/form-data",
     *       @OA\Schema(
     *           required={"traveller_id","title","first_name","last_name","date_of_birth","gender","nationality","id_type","id_number","issue_date","expiry_date","issue_country"},
     *           @OA\Property(property="language_code", type="string",description="pass language_code either 'en' or 'ar'", default="en" ),
     *           @OA\Property(property="traveller_id", type="string", default="" ,description="need to pass a traveller id as user want to update"),
     *           @OA\Property(property="title", type="string",description="pass title either 'mr','mrs' or 'miss'", default="" ),
     *           @OA\Property(property="first_name", type="string",description="need to pass a first name", default="" ),
     *           @OA\Property(property="second_name", type="string",description="pass a second name", default="" ),
     *           @OA\Property(property="last_name", type="string",description="need to pass last name", default="" ),
     *           @OA\Property(property="date_of_birth", type="string",description="need to pass date of birth in Y-m-d format", default="" ),
     *           @OA\Property(property="gender", type="string",description="need to pass gender either 'male' or 'female'", default="" ),
     *           @OA\Property(property="nationality", type="string",description="need to pass iso_code that fetch by call API 'get-countries'", default="" ),
     *           @OA\Property(property="id_type", type="string",description="need to pass id type either 'passport' or 'national_id'", default="" ),
     *           @OA\Property(property="id_number", type="integer",description="need to pass id number as passed id type", default="" ),
     *           @OA\Property(property="issue_date", type="string",description="need to pass issue date in Y-m-d format", default="" ),
     *           @OA\Property(property="expiry_date", type="string",description="need to pass expiry date in Y-m-d format", default="" ),
     *           @OA\Property(property="issue_country", type="string",description="need to pass iso_code that fetch by call API 'get-countries'", default="" ),
     *           @OA\Property(property="status", type="string",description="pass status either 'active' or 'inactive'", default="" ),
     *           @OA\Property(property="upload_document", type="string", format="binary",description="select document image *ensure that you are uploading an image is 2MB or less and one of the following types: JPG,JPEG, or PNG"),
     *           )
     *     ),
     *   ),
     *   @OA\Response(
     *      response=200,
     *       description="Success",
     *      @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *   ),
     *   @OA\Response(
     *      response=401,
     *       description="Unauthenticated"
     *   ),
     *   @OA\Response(
     *      response=400,
     *      description="Bad Request"
     *   ),
     *   @OA\Response(
     *      response=404,
     *      description="not found"
     *   ),
     *      @OA\Response(
     *          response=403,
     *          description="Forbidden"
     *      )
     * )
     * */
    public function updateTraveller(Request $request)
    {
        $return = [
            'status' => 0,
            'data' => [],
            'message' => 'Something went wrong'
        ];
        try {
            $travellerId = CustomerTraveller::where('id', request()->input('traveller_id'))
                ->where('customer_id', Auth()->user()->id)
                ->value('id');

            if (!$travellerId) {
                return $this->sendError(no_record_found, [], 400);
            }

            $travellerData = $request->all();
            $requestData = [
                'traveller_id' => $travellerData['traveller_id'] ?? '',
                'title' => $travellerData['title'] ?? '',
                'first_name' => $travellerData['first_name'] ?? '',
                'second_name' => $travellerData['second_name'] ?? '',
                'last_name' => $travellerData['last_name'] ?? '',
                'date_of_birth' => $travellerData['date_of_birth'] ?? '',
                'issue_date' => $travellerData['issue_date'] ?? '',
                'expire_date' => $travellerData['expire_date'] ?? '',
                'status' => in_array($travellerData['status'], ['active', 'inactive']) ? $travellerData['status'] : 'inactive',
                'document' => $travellerData['upload_document'] ?? '',
                'relationship' => $travellerData['relationship'] ?? '',
                'email' => $travellerData['email'] ?? '',
                'phone' => $travellerData['phone'] ?? '',
                'address' => $travellerData['address'] ?? '',
                'passport_number' => $travellerData['passport_number'] ?? '',
                'passport_nationality' => $travellerData['passport_nationality'] ?? '',
                'passport_issued_country' => $travellerData['passport_issued_country'] ?? '',
                'national_id' => $travellerData['national_id'] ?? '',
                'national_id_nationality' => $travellerData['national_id_nationality'] ?? '',
                'national_id_issued_country' => $travellerData['national_id_issued_country'] ?? '',
                'iqama_id' => $travellerData['iqama_id'] ?? '',
                'iqama_id_nationality' => $travellerData['iqama_id_nationality'] ?? '',
                'iqama_id_expire_date' => isset($travellerData['iqama_id_expire_date']) && strtotime($travellerData['iqama_id_expire_date'])
                    ? $travellerData['iqama_id_expire_date']
                    : null,
                'frequently_flyer_airline_name' => $travellerData['frequently_flyer_airline_name'] ?? '',
                'frequently_flyer_programme' => $travellerData['frequently_flyer_programme'] ?? '',
                'frequently_flyer_number' => $travellerData['frequently_flyer_number'] ?? '',
                'customer_id' => Auth::id(),
                'national_id_expiry_date' => $travellerData['nationalIdExpireDate'] ?? '',
                'national_id_date_of_birth' => $travellerData['date_birth'] ?? '',
            ];

            $response = CustomerTraveller::where('id', $travellerId)->update($requestData);

            if ($response) {
                $updatedTraveller = CustomerTraveller::find($travellerId);
                $updatedTraveller['nationalIdExpireDate'] = $updatedTraveller['national_id_expiry_date'];
                $updatedTraveller['date_birth'] = $updatedTraveller['national_id_date_of_birth'];
                // $response['data']->date_birth = $response['data']->national_id_date_of_birth;
                unset($updatedTraveller['national_id_expiry_date']);
                unset($updatedTraveller['national_id_date_of_birth']);

                return $this->sendResponse([$updatedTraveller], 'Traveller Updated Successfully!', true);
            }
            return $this->sendError('Traveller Not Saved', [], 200);
        } catch (\Exception $e) {
            return $this->sendError('Something went wrong', [$e->getMessage()], 200);
        }
    }

    /**
     * @OA\Delete(
     *   path="/v1/customer/delete-traveller/{traveller_id}",
     *   security={
     *     {"bearerAuth": {}}
     *   },
     *   tags={"Customer"},
     *   summary="Delete traveller",
     *   description="need to pass traveller Id to delete traveller for multi traveller delete pass traveller id separated by commas",
     *   operationId="traveller-delete",
     *      @OA\Parameter(
     *         name="traveller_id",
     *         in="path",
     *         required=true,
     *         description="need to pass traveller Id to delete traveller for multi traveller delete pass traveller id separated by commas"
     *      ),
     * @OA\Parameter(
     *      name="language_code",
     *      in="query",
     *      required=false,
     *      description="Language code parameter either 'en' or 'ar'",
     *      @OA\Schema(
     *          type="string",
     *          example="en",
     *      )
     *   ),
     *   @OA\Response(
     *      response=200,
     *       description="Success",
     *      @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *   ),
     *   @OA\Response(
     *      response=401,
     *       description="Unauthenticated"
     *   ),
     *   @OA\Response(
     *      response=400,
     *      description="Bad Request"
     *   ),
     *   @OA\Response(
     *      response=404,
     *      description="not found"
     *   ),
     *      @OA\Response(
     *          response=403,
     *          description="Forbidden"
     *      )
     * )
     * )
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {

            $customer_id = Auth::id();


            $travellerIDs = explode(',', $id);
            $message = "";
            foreach ($travellerIDs as $teavell_id) {
                $traveller_id = CustomerTraveller::where('id', $teavell_id)->where('customer_id', $customer_id)->value('id');
                if ($traveller_id) {
                    $response = CustomerTraveller::deleteTravellers($traveller_id);
                    $message .= $response['message'] . '</br>';
                }
            }
            if (empty($response)) {
                return $this->sendError(no_record_found, [], 200);
            } else {
                return $this->sendResponse([], 'Traveller Deleted Successfully.');
            }
            // } else {
            //     return $this->sendError('Traveller Not Found', [], 200);
            // }
        } catch (Exception $e) {
            $success = [];
            return $this->sendError($success, 'Something went wrong', ['error' => $e], 500);
        }
    }
}
