<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use App\Models\Bookings;
use App\Models\Suppliers;
use App\Models\ServiceType;
use App\Models\Agency;
use DataTables;

class BookingTestController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // $results = Bookings::get();
        // $dataList = array();
        // foreach($results as $result)
        // {
        //     $dataList[] = array('id'=>$result->id, 'sub_total' => $result->sub_total);
        // }
        //print_r($dataList);
        //exit;
        if ($request->ajax()) {
            $i = 0;
            //$results = Bookings::latest()->get();//->orderBy('created_at', 'DESC')
            $results = Bookings::select('*')->orderBy('created_at', 'DESC');
            return DataTables::of($results)
                ->addIndexColumn()
                ->filter(function ($instance) use ($request) {
                    if ($request->get('booking_date')) {
                        $instance->where('booking_date', date("Y-m-d", strtotime($request->get('booking_date'))));
                    }
                    if ($request->get('supplier_id')) {
                        $instance->where('supplier_id', $request->get('supplier_id'));
                    }
                    if ($request->get('service_id')) {
                        $instance->where('service_id', $request->get('service_id'));
                    }
                    if ($request->get('system_ref_id')) {
                        $system_ref_id = $request->get('system_ref_id');
                        $instance->where('supplier_booking_ref', 'like', '%' . $system_ref_id . '%');
                    }
                    if ($request->get('booking_id')) {
                        $booking_ref = $request->get('booking_ref');
                        $instance->where('booking_ref', 'like', '%' . $booking_ref . '%');
                    }
                    if ($request->get('price_from')) {
                        $instance->where('booking_amount', '>=', $request->get('price_from'));
                    }
                    if ($request->get('price_to')) {
                        $instance->where('booking_amount', '<=', $request->get('price_to'));
                    }
                    if ($request->get('pnr_number')) {
                        $pnr_number = $request->get('pnr_number');
                        //$instance->where('pnr_number', 'like', '%' . $pnr_number . '%');
                    }
                    if ($request->get('customer_id')) {
                        $instance->where('customer_id', $request->get('customer_id'));
                    }
                    if ($request->get('booking_status')) {
                        $instance->where('booking_status', $request->get('booking_status'));
                    }
                    if ($request->get('payment_status')) {
                        //$instance->where('payment_status', $request->get('payment_status'));
                    }
                    if ($request->get('agency_id')) {
                        $instance->where('agency_id', $request->get('agency_id'));
                    }
                    if ($request->has('search') && ! is_null($request->get('search')['value']) ) {
                        $regex = $request->get('search')['value'];
                        $instance->where('booking_ref', 'like', '%' . $regex . '%');
                    }
                })
                ->addColumn("booking_type", function ($data) {
                    if (empty($data->booking_type)) {
                        return "N/A";
                    }
                    return $data->booking_type;
                })
                ->addColumn("supplier_booking_ref", function ($data) {
                    if (empty($data->supplier_booking_ref)) {
                        return "N/A";
                    }
                    return $data->supplier_booking_ref;
                })
                ->addColumn("booking_ref", function ($data) {
                    if (empty($data->booking_ref)) {
                        return "N/A";
                    }
                    return $data->booking_ref;
                })
                ->addColumn("supplier_id", function ($data) {
                    if (empty($data->supplier_id)) {
                        return "N/A";
                    }
                    return ($data->supplier_id == 9)? 'AMADEUS' : '';
                })
                ->addColumn("booking_amount", function ($data) {
                    if (empty($data->booking_amount)) {
                        return "N/A";
                    }
                    return $data->booking_amount;
                })
                ->addColumn("is_guest", function ($data) {
                    return ($data->is_guest == 'true')? 'Yes' : 'No';
                })
                ->addColumn("email", function ($data) {
                    if (empty($data->email)) {
                        return "N/A";
                    }
                    return $data->email;
                })
                ->addColumn("phone", function ($data) {
                    if (empty($data->phone)) {
                        return "N/A";
                    }
                    return $data->phone_country_code.$data->phone;
                })
                ->addColumn("description", function ($data) {
                    if (empty($data->description)) {
                        return "N/A";
                    }
                    return $data->description;
                })
                ->addColumn("booking_date", function ($data) {
                    if (empty($data->booking_date)) {
                        return "N/A";
                    }
                    return getDateTimeZone($data->booking_date);
                })
                ->addColumn("pnr_number", function ($data) {
                    if (empty($data->pnr_number)) {
                        return "N/A";
                    }
                    return $data->pnr_number;
                })
                ->addColumn("booking_status", function ($data) {
                    if (empty($data->booking_status)) {
                        return "N/A";
                    }
                    $bookingStatusContent = '
                    <div class="booking-status '.$data->booking_status.'">
                        '.ucfirst($data['booking_status']).'
                    ';
                    if($data->booking_status_message != '') {
                        $bookingStatusContent .= '<br/><span class="booking-status-message">('.$data['booking_status_message'].')</span>';
                    }
                    $bookingStatusContent .= '</div>';

                    return $bookingStatusContent;
                })
                ->addColumn("action", function ($data) {
                    $actionContent = '
                    <a href="'. route('booking.show',$data->id).'" title="View">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="#2188ef"
                        width="20" height="20" x="0px" y="0px" viewBox="0 0 576 512"><path d="M288 80c-65.2 0-118.8 29.6-159.9 67.7C89.6 183.5 63 226 49.4 256c13.6 30 40.2 72.5 78.6 108.3C169.2 402.4 222.8 432 288 432s118.8-29.6 159.9-67.7C486.4 328.5 513 286 526.6 256c-13.6-30-40.2-72.5-78.6-108.3C406.8 109.6 353.2 80 288 80zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1c3.3 7.9 3.3 16.7 0 24.6c-14.9 35.7-46.2 87.7-93 131.1C433.5 443.2 368.8 480 288 480s-145.5-36.8-192.6-80.6C48.6 356 17.3 304 2.5 268.3c-3.3-7.9-3.3-16.7 0-24.6C17.3 208 48.6 156 95.4 112.6zM288 336c44.2 0 80-35.8 80-80s-35.8-80-80-80c-.7 0-1.3 0-2 0c1.3 5.1 2 10.5 2 16c0 35.3-28.7 64-64 64c-5.5 0-10.9-.7-16-2c0 .7 0 1.3 0 2c0 44.2 35.8 80 80 80zm0-208a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"/></svg>
                    </a>
                    <a href="'. route('admin.booking.supplier-log',$data->id) .'" target="blank" class="log-booking" title="Log">
                        <img src="'. URL::asset('assets/images/icon-zip.png') .'" width="20" height="20" />
                    </a>
                    ';
                    if ($data->booking_status == 'confirmed') {
                        $actionContent .= '
                        <a href="#" class="cancel-booking" data-id="'.$data->id.'" title="Cancel">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="#FF0000" width="20" height="20" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg>
                        </a>';
                    }
                    return $actionContent;
                })
                ->rawColumns(["action", "booking_status"])
                ->make(true);
        }
        $data["title"] = "Manage Booking";
        $data['heading'] = "Booking";
        $data['supplierDataList'] = Suppliers::get()->toArray();
        $data['getServiceType'] = ServiceType::get()->toArray();
        $data['getAgency'] = Agency::get()->toArray();
        return view("admin.booking.index2", $data);
    }
}
