<?php

namespace App\Http\Controllers\Admin;

use App\Models\SiteSetting;
use Illuminate\Http\Request;
use App\Models\InvoiceSetting;
use App\Models\LoyaltyPointSetting;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class GeneralSettingController extends Controller
{
    public function index()
    {
        $loyalty_point_settings = LoyaltyPointSetting::first();
        $site_settings = SiteSetting::first();
        $invoice_settings = InvoiceSetting::first();
        return view('admin.general-setting.index', ['loyalty_settings' => $loyalty_point_settings, 'site_settings' => $site_settings, 'invoice_settings' => $invoice_settings]);
    }


    public function store(Request  $request)
    {
        try {
            $requestData = $request->all();
            if ($requestData['save_type'] == 'loyalty-settings') {
                $validated = $request->validate([
                    'point_to_amount' => 'required|numeric',
                ]);
                $loyaltySettings = LoyaltyPointSetting::updateOrCreate(
                    ['id' => $requestData['id']],
                    [
                        'expiry_year' => $requestData['expiry_year'],
                        'expiry_month' => $requestData['expiry_month'],
                        'expiry_day' => $requestData['expiry_day'],
                        'point_to_amount' => $requestData['point_to_amount'],
                    ]
                );

                if ($loyaltySettings) {
                    return response()->json(['status' => 'success', 'message' => 'Loyalty settings saved successfully']);
                }
            } else if ($requestData['save_type'] == 'site-settings') {
                $validated = $request->validate([
                    'site_name' => 'required|string|max:255',
                    'contact_email' => 'required|email',
                    'phone_code' => 'required|string',
                    'phone_no' => 'required|string',
                    'site_logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                ]);

                $imagePath = null;

                if ($request->hasFile('site_logo')) {
                    $imagePath = $request->file('site_logo')->store('site_settings', 'public');
                }

                $siteSettings = SiteSetting::updateOrCreate(
                    ['id' => $requestData['id']],
                    [
                        'site_title' => $requestData['site_name'],
                        'contact_email' => $requestData['contact_email'],
                        'phone_code' => $requestData['phone_code'],
                        'phone_no' => $requestData['phone_no'],
                        'site_logo' => $imagePath ?? SiteSetting::find($requestData['id'])->site_logo ?? null,
                    ]
                );

                if ($siteSettings) {
                    return response()->json(['status' => 'success', 'message' => 'Site settings saved successfully']);
                } else {
                    return response()->json(['status' => 'error', 'message' => 'Failed to save settings']);
                }
            } else if ($requestData['save_type'] == 'invoice-settings') {
                $invoiceSettings = InvoiceSetting::find($requestData['id']);
                $validated = $request->validate([
                    'title_en' => 'required|string|max:255',
                    'title_ar' => 'required|string|max:255',
                    'address_en' => 'required|string|max:255',
                    'address_ar' => 'required|string|max:255',
                    'city_en' => 'required|string|max:255',
                    'city_ar' => 'required|string|max:255',
                    'country_en' => 'required|string|max:255',
                    'country_ar' => 'required|string|max:255',
                    'pincode' => 'required|integer',
                    'contact_email' => 'required|email',
                    'phone_code' => 'required|string',
                    'phone_no' => 'required|string',
                    'invoice_logo_en' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'invoice_logo_ar' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'sar_icon' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'usd_icon' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                ]);

                $imagePathEn = $imagePathAr = $sarIcon = $usdIcon = null;

                // Invoice Logo EN
                if ($request->hasFile('invoice_logo_en')) {
                    // Delete old file if exists
                    if ($invoiceSettings  && isset($invoiceSettings->invoice_logo_en)) {
                        Storage::disk('public')->delete($invoiceSettings->invoice_logo_en);
                    }
                    $imagePathEn = $request->file('invoice_logo_en')->store('invoice_settings', 'public');
                }

                // Invoice Logo AR
                if ($request->hasFile('invoice_logo_ar')) {
                    if ($invoiceSettings  && isset($invoiceSettings->invoice_logo_ar)) {
                        Storage::disk('public')->delete($invoiceSettings->invoice_logo_ar);
                    }
                    $imagePathAr = $request->file('invoice_logo_ar')->store('invoice_settings', 'public');
                }

                // SAR Icon
                if ($request->hasFile('sar_icon')) {
                    if ($invoiceSettings  && isset($invoiceSettings->sar_icon)) {
                        Storage::disk('public')->delete($invoiceSettings->sar_icon);
                    }
                    $sarIcon = $request->file('sar_icon')->store('invoice_settings', 'public');
                }

                // USD Icon
                if ($request->hasFile('usd_icon')) {
                    if ($invoiceSettings  && isset($invoiceSettings->usd_icon)) {
                        Storage::disk('public')->delete($invoiceSettings->usd_icon);
                    }
                    $usdIcon = $request->file('usd_icon')->store('invoice_settings', 'public');
                }

                $invoiceSettings = InvoiceSetting::updateOrCreate(
                    ['id' => $requestData['id']],
                    [
                        'title_en' => $requestData['title_en'],
                        'title_ar' => $requestData['title_ar'],
                        'address_en' => $requestData['address_en'],
                        'address_ar' => $requestData['address_ar'],
                        'city_en' => $requestData['city_en'],
                        'city_ar' => $requestData['city_ar'],
                        'country_en' => $requestData['country_en'],
                        'country_ar' => $requestData['country_ar'],
                        'pincode' => $requestData['pincode'],
                        'email' => $requestData['contact_email'],
                        'phone_code' => $requestData['phone_code'],
                        'phone_no' => $requestData['phone_no'],
                        'logo_en' => $imagePathEn ?? $invoiceSettings->logo_en ?? null,
                        'logo_ar' => $imagePathAr ?? $invoiceSettings->logo_ar ?? null,
                        'sar_icon' => $sarIcon ?? $invoiceSettings->sar_icon ?? null,
                        'usd_icon' => $usdIcon ?? $invoiceSettings->usd_icon ?? null,
                    ]
                );

                if ($invoiceSettings) {
                    return response()->json(['status' => 'success', 'message' => 'Invoice settings saved successfully']);
                } else {
                    return response()->json(['status' => 'error', 'message' => 'Failed to save settings']);
                }
            }
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }
}
