<?php

namespace App\Http\Controllers\Admin\Markups;

use App\Http\Controllers\Controller;
use App\Models\MarkupSetting;
use Illuminate\Http\Request;

class MarkupSettingController extends Controller
{
    public function applyMarkupToList(Request $request,$id = null)
    {
     
    
        $markup = $request->validate([
            'show_markup_hotel' => 'boolean',
           'show_markup_flight' => 'boolean',
        
        ]);

        $createMarkupSetting = MarkupSetting::updateOrCreate(
            ['id' => $id],
            [
                'apply_markup_hotel_list' => $markup['show_markup_hotel'],
                'apply_markup_flight_list' => $markup['show_markup_flight'],
            ]
        );
        
        if($createMarkupSetting){
            return response()->json([
                'success' => true,
                'message' => 'Markup has been applied successfully',
                'data' => ''
            ]);
        }else{
            return response()->json([
                'success' => false,
                'message' => 'Markup has not been applied',
                'data' => ''
            ]);
        }


    }
}
