<?php

/**
 * @package     NegFares
 * @subpackage   NegFares
 * @Copyright(C) 2023 [Travel Portal].
 * @Version 1.0.0
 * module of the  NegFares.
 */

namespace App\Http\Controllers\Admin;

use App\Enums\Locale;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Carbon;
use App\Models\Setting;
use App\Models\Airport;
use App\Models\NegFare;
use App\Traits\CommonService;
use DB;

class NegFareController extends Controller
{
    use CommonService;

    /**
     * Display a listing of the markups.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title']="Neg Fare List";
        $header['heading']="Neg Fare List";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'destination' => (request()->input('destination') != NULL) ? request()->input('destination') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('origin') != NULL) {
            $appliedFilter['where'][] = ['origin', '=', request()->input('origin')];
        }

        if (request()->input('destination') != NULL) {
            $appliedFilter['where'][] = ['destination', '=', request()->input('destination')];
        }

        $negFareDataList = NegFare::getNegFares($appliedFilter);
        $negFareDataCount = NegFare::count();

        $negFareData = $negFareDataList['data'];
        if ($negFareDataCount > 0) {
            //$negFareData->data = $negFareData->data->toArray();
            //echo "<pre>"; print_r($negFareData); die;
            foreach ($negFareData as $key => &$negFare) {
                $negFare->from_airports = str_replace(',', ', ', $negFare->from_airports);
                $negFare->to_airports = str_replace(',', ', ', $negFare->to_airports);
                $negFare->period = date('d-M-Y', strtotime($negFare->from_date)).' to '.date('d-M-Y', strtotime($negFare->to_date));
                //echo "<pre>"; print_r($negFare); die;
            }
        }
        if ($negFareData['status'] == 1) {
            return view('admin/neg-fare/index')->with(['header'=>$header, 'appliedFilter'=>$appliedFilter, 'negFareDataCount'=>$negFareDataCount, 'negFareData'=>$negFareData,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/neg-fare/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter, 'negFareData'=>$negFareData,'negFareDataCount'=>$negFareDataCount,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    public function getAirports() {
        $getAirports = Airport::with('airportName')->where('status','active')->get()->toArray();
        $airports = [];
        if (count($getAirports) > 0) {
            foreach ($getAirports as $airport) {
                if ($airport['airport_name'][0]['language_code'] == Locale::English->value) {
                    $airportName = $airport['airport_name'][0]['airport_name'];
                } else {
                    $airportName = $airport['airport_name'][1]['airport_name'];
                }
                $airports[$airport['iata_code']] = $airportName;
            }
            asort($airports);
        }
        return $airports;
    }


    /**
     * Show the form for creating a new markups.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "Neg Fare - Add";
        $header['heading'] = "Neg Fare - Add";

        $airports = $this->getAirports();

        return view('admin/neg-fare/add')->with(['header' => $header, 'airports' => $airports]);;
    }

    /**
     * Store a newly created markups in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only([
            'title',
            'from_airports',
            'to_airports',
            'from_date',
            'to_date',
            'status'
        ]);

        $rules = [
            'title' => 'required',
            'from_airports' => 'required',
            'to_airports' => 'required',
            'from_date' => 'required',
            'to_date' => 'required',
            'status' => 'required'
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $requestData = [
            'title' => $requestData['title'],
            'from_airports' => implode(',', $requestData['from_airports']),
            'to_airports' => implode(',', $requestData['to_airports']),
            'from_date' => date('Y-m-d', strtotime($requestData['from_date'])),
            'to_date' => date('Y-m-d', strtotime($requestData['to_date'])),
            'status' => $requestData['status'],
        ];

        $response = NegFare::createNegFare($requestData);
        if (!empty($response['data'])) {
            return redirect()->route('neg-fare.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->back()->with('error', $response['message']);
        }
    }

    /**
     * Display the specified markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "Neg Fare - View";
        $header['heading'] = "Neg Fare - View";

        $filter = array(
            'id' => $id
        );

        $response = NegFare::getNegFares($filter);
        if ($response['status'] == 1 && !empty($response['data'])) {
            $airports = $this->getAirports();
            $negFareDetails = $response['data']->toArray();

            $negFareDetails['from_airports'] = implode('<br/>', $this->getAirportNames($airports, $negFareDetails['from_airports']));
            $negFareDetails['to_airports'] = implode('<br/>', $this->getAirportNames($airports, $negFareDetails['to_airports']));
            $negFareDetails['from_date'] = date('d-M-Y', strtotime($negFareDetails['from_date']));
            $negFareDetails['to_date'] = date('d-M-Y', strtotime($negFareDetails['to_date']));

            return view('admin/neg-fare/view')->with(['header' => $header, 'negFareDetails' => $negFareDetails]);
        } else {
            return redirect()->route('neg-fare.index')->with('error', $response['message']);
        }
    }

    /**
     * Show the form for editing the specified markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "Flight - Edit";
        $header['heading'] = "Flight - Edit";

        $filter = array(
            'id' => $id
        );

        $response = NegFare::getNegFares($filter);

        $airports = $this->getAirports();

        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/neg-fare/edit')->with(['header' => $header, 'negFareDetails' => $response['data'], 'airports' => $airports]);
        } else {
            return redirect()->to('neg-fare.index')->with('error', $response['message']);
        }
    }

    /**
     * Update the specified markups in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $requestData = $request->only([
            'id',
            'title',
            'from_airports',
            'to_airports',
            'from_date',
            'to_date',
            'status'
        ]);

        $rules = [
            'id' => 'required',
            'title' => 'required',
            'from_airports' => 'required',
            'to_airports' => 'required',
            'from_date' => 'required',
            'to_date' => 'required',
            'status' => 'required'
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $requestData = [
            'id' => $requestData['id'],
            'title' => $requestData['title'],
            'from_airports' => implode(',', $requestData['from_airports']),
            'to_airports' => implode(',', $requestData['to_airports']),
            'from_date' => date('Y-m-d', strtotime($requestData['from_date'])),
            'to_date' => date('Y-m-d', strtotime($requestData['to_date'])),
            'status' => $requestData['status'],
        ];

        $response = NegFare::updateNegFare($requestData);

        if ($response['status'] == 1 &&  !empty($response['data'])) {
            return redirect()->route('neg-fare.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->route('neg-fare.index', $response)->with('error', $response['message']);

        }
    }

    /**
     * Remove the specified markups from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    /**
     * Display a listing of the markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function getListData(Request $request) {
        $header['title']="Neg Fare List";
        $header['heading']="Neg Fare List";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'destination' => (request()->input('destination') != NULL) ? request()->input('destination') : '',
        );

        if (request()->input('origin') != NULL) {
            $appliedFilter['where'][] = ['origin', '=', request()->input('origin')];
        }

        if (request()->input('destination') != NULL) {
            $appliedFilter['where'][] = ['destination', '=', request()->input('destination')];
        }

        $negFareDataList = NegFare::getNegFares($appliedFilter);
        $negFareDataCount = NegFare::count();
        $negFareData = $negFareDataList['data'];
        if ($negFareData['status'] == 1) {
            return view('admin/neg-fare/index')->with(['header'=>$header, 'appliedFilter'=>$appliedFilter, 'negFareDataCount'=>$negFareDataCount, 'negFareData'=>$negFareData,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/neg-fare/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter, 'negFareData'=>$negFareData,'negFareDataCount'=>$negFareDataCount,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Remove the specified markups from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteNegFare($id)
    {
        if(!hasPermission('NegFares','delete')){
            return view('admin/401');
        }
        $url = URL::previous();

        $response = NegFare::deleteNegFare($id);

        if ($response['status'] == 1) {
            return redirect()->to($url)->with('success', $response['message']);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }

}

