<?php

namespace App\Http\Controllers\Admin\SeoLinks;

use App\Models\Setting;
use Illuminate\Http\Request;
use App\Models\FeaturedGuide;
use App\Models\SeoTrendingFlight;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;


class FeaturedGuideController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title'] = "Featured Guides";
        $header['heading'] = "Featured Guides";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'name' => (request()->input('name') != NULL) ? request()->input('name') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('name') != NULL) {
            $appliedFilter['where'][] = ['name', '=', request()->input('name')];
        }

        if (request()->input('status') != NULL) {
            $appliedFilter['where'][] = ['status', '=', request()->input('status')];
        }

        $featuredGuideDataList = featuredGuide::getFeaturedGuides($appliedFilter);
        $featuredGuideDataCount = featuredGuide::count();

        $featuredGuideData = $featuredGuideDataList['data'];
        if ($featuredGuideData['status'] == 1) {
            return view('admin/featured-guide/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'featuredGuideCount' => $featuredGuideDataCount, 'featuredGuideData' => $featuredGuideData, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/featured-guide/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'featuredGuideData' => $featuredGuideData, 'featuredGuideDataCount' => $featuredGuideDataCount, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "Featured Guide- Add";
        $header['heading'] = "Featured Guide - Add";


        return view('admin/featured-guide/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only([
            'name',
            'guide_url',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'guide_url' => 'required | url',
            'status' => 'required',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $newFileName = $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        }

        $featureGuide = FeaturedGuide::create(
            [
                'name' => $requestData['name'],
                'url' => $requestData['guide_url'],
                'status' => $requestData['status'],
                'content' => $requestData['content'] ?? '',
                'arabic_content' => $requestData['arabic_content'],
                'title' => $requestData['title'] ?? '',
                'arabic_title' => $requestData['arabic_title'] ?? '',
                'sub_title' => $requestData['sub_title'] ?? '',
                'arabic_sub_title' => $requestData['arabic_sub_title'] ?? '',
                'banner_title' => $requestData['banner_title'] ?? '',
                'arabic_banner_title' => $requestData['arabic_banner_title'] ?? '',
                'banner' => $newFileName ?? '',
                'banner_sub_title' => $requestData['banner_sub_title'] ?? '',
                'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'] ?? '',

            ]
        );
        if ($featureGuide) {
            return redirect()->route('featured-guides.index')->with('success', 'Featured Guide Created Successully');
        } else {
            return redirect()->back()->with('error', 'Error Creating Featured Guides');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "Featured Guides - View";
        $header['heading'] = "Featured Guides - View";


        $featuredGuideDetails = FeaturedGuide::where('id', $id)->get();


        if (!$featuredGuideDetails->isEmpty()) {

            return view('admin/featured-guide/view')->with([
                'header' => $header,
                'featuredGuideDetails' => $featuredGuideDetails->first(),
            ]);
        } else {
            return redirect()->route('featured-guides.index')->with('error', 'Error');
        }
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "Featured Guides - View";
        $header['heading'] = "Featured Guides - View";


        $featuredGuideDetails = FeaturedGuide::where('id', $id)->get();


        if (!$featuredGuideDetails->isEmpty()) {

            return view('admin/featured-guide/update')->with([
                'header' => $header,
                'featuredGuideDetails' => $featuredGuideDetails->first(),
            ]);
        } else {
            return redirect()->route('featured-guides.index')->with('error', 'Error');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $requestData = $request->only([
            'name',
            'guide_url',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);


        $rules = [
            'name' => 'required|string|max:255',
            'guide_url' => 'required|url',
            'status' => 'required|boolean',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];


        $this->validate($request, $rules);


        $featureGuide = FeaturedGuide::find($id);


        if (!$featureGuide) {
            return redirect()->route('featured-guides.index')->with('error', 'Featured Guide not found');
        }

        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $featureGuide->banner= $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        }

        $featureGuide->name = $requestData['name'];
        $featureGuide->url = $requestData['guide_url'];
        $featureGuide->status = $requestData['status'];
        $featureGuide->content = $requestData['content'] ?? '';
        $featureGuide->arabic_content = $requestData['arabic_content'];
        $featureGuide->title = $requestData['title'] ?? '';
        $featureGuide->arabic_title = $requestData['arabic_title'] ?? '';
        $featureGuide->sub_title = $requestData['sub_title'] ?? '';
        $featureGuide->arabic_sub_title = $requestData['arabic_sub_title'] ?? '';
        $featureGuide->banner_title = $requestData['banner_title'] ?? '';
        $featureGuide->arabic_banner_title = $requestData['arabic_banner_title'] ?? '';
        $featureGuide->banner_sub_title = $requestData['banner_sub_title'] ?? '';
        $featureGuide->arabic_banner_sub_title = $requestData['arabic_banner_sub_title'] ?? '';


        if ($featureGuide->save()) {
            return redirect()->route('featured-guides.index')->with('success', 'Featured Guide updated successfully');
        } else {
            return redirect()->back()->with('error', 'Error updating Featured Guide');
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        //    
    }




    public function  deleteFeaturedGuide($id)
    {

        $featureGuide = FeaturedGuide::find($id);


        if (!$featureGuide) {
            return redirect()->route('featured-guides.index')->with('error', 'Featured Guide not found');
        }

        $url = URL::previous();
        if ($featureGuide->delete()) {

            return redirect()->to($url)->with('success', 'Featured Guide deleted successfully');
        } else {
            return redirect()->to($url)->with('error', 'Error deleting Featured Guide');
        }
    }
}
