<?php

namespace App\Http\Controllers\Admin\SeoLinks;

use App\Models\Setting;
use Illuminate\Http\Request;
use App\Models\PopularAttraction;

use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;

class PopularAttractionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title'] = "Popular Attractions";
        $header['heading'] = "Popular Attractions";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'name' => (request()->input('name') != NULL) ? request()->input('name') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('name') != NULL) {
            $appliedFilter['where'][] = ['name', '=', request()->input('name')];
        }

        if (request()->input('status') != NULL) {
            $appliedFilter['where'][] = ['status', '=', request()->input('status')];
        }

        $popularAttractionDataList = PopularAttraction::getPopularAttractions($appliedFilter);
        $popularAttractionDataCount = PopularAttraction::count();

        $popularAttractionData = $popularAttractionDataList['data'];
        if ($popularAttractionData['status'] == 1) {
            return view('admin/popular-attraction/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'popularAttractionCount' => $popularAttractionDataCount, 'popularAttractionData' => $popularAttractionData, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/popular-attraction/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'popularAttractionData' => $popularAttractionData, 'popularAttractionDataCount' => $popularAttractionDataCount, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "Popular Attractions- Add";
        $header['heading'] = "Popular Attractions - Add";


        return view('admin/popular-attraction/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only([
            'name',
            'popular_url',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'popular_url' => 'required | url',
            'status' => 'required',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);
        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $newFileName = $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        }

        $popularAttraction = PopularAttraction::create(
            [
                'name' => $requestData['name'],
                'url' => $requestData['popular_url'],
                'status' => $requestData['status'],
                'content' => $requestData['content'] ?? '',
                'arabic_content' => $requestData['arabic_content'],
                'title' => $requestData['title'] ?? '',
                'arabic_title' => $requestData['arabic_title'] ?? '',
                'sub_title' => $requestData['sub_title'] ?? '',
                'arabic_sub_title' => $requestData['arabic_sub_title'] ?? '',
                'banner_title' => $requestData['banner_title'] ?? '',
                'arabic_banner_title' => $requestData['arabic_banner_title'] ?? '',
                'banner' => $newFileName ?? '',
                'banner_sub_title' => $requestData['banner_sub_title'] ?? '',
                'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'] ?? '',

            ]
        );
        if ($popularAttraction) {
            return redirect()->route('popular-attraction.index')->with('success', 'Popular Attraction Created Successully');
        } else {
            return redirect()->back()->with('error','Error Creating Popular Attraction');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "Popular Attractions - View";
        $header['heading'] = "Popular Attractions - View";
    
       
        $popularAttractionDetails = PopularAttraction::where('id', $id)->get();
    
       
        if (!$popularAttractionDetails->isEmpty()) {
           
            return view('admin/popular-attraction/view')->with([
                'header' => $header,
                'popularAttractionDetails' => $popularAttractionDetails->first(), 
            ]);
        } else {
            return redirect()->route('popular-attraction.index')->with('error', 'Error');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "Popular Attractions - View";
        $header['heading'] = "Popular Attractions - View";
    
      
        $popularAttractionDetails  =PopularAttraction::where('id', $id)->get();
    
     
        if (!$popularAttractionDetails ->isEmpty()) {
       
            return view('admin/popular-attraction/update')->with([
                'header' => $header,
                'popularAttractionDetails' => $popularAttractionDetails ->first(), 
            ]);
        } else {
            return redirect()->route('popular-attraction.index')->with('error', 'Error');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $requestData = $request->only([
            'name',
            'popular_url',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);
    
       
        $rules = [
            'name' => 'required|string|max:255',
            'popular_url' => 'required|url',
            'status' => 'required|boolean',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];
    
      
        $this->validate($request, $rules);
    
      
        $popularAttraction = PopularAttraction::find($id);
    
       
        if (! $popularAttraction) {
            return redirect()->route('popular-attraction.index')->with('error', 'Popular Attractions not found');
        }
    
        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $popularAttraction->banner= $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        }
      
        $popularAttraction->name = $requestData['name'];
        $popularAttraction->url = $requestData['popular_url'];
        $popularAttraction->status = $requestData['status'];
        $popularAttraction->content = $requestData['content'] ?? '';
        $popularAttraction->arabic_content = $requestData['arabic_content'];
        $popularAttraction->title = $requestData['title'] ?? '';
        $popularAttraction->arabic_title = $requestData['arabic_title'] ?? '';
        $popularAttraction->sub_title = $requestData['sub_title'] ?? '';
        $popularAttraction->arabic_sub_title = $requestData['arabic_sub_title'] ?? '';
        $popularAttraction->banner_title = $requestData['banner_title'] ?? '';
        $popularAttraction->arabic_banner_title = $requestData['arabic_banner_title'] ?? '';
        $popularAttraction->banner_sub_title = $requestData['banner_sub_title'] ?? '';
        $popularAttraction->arabic_banner_sub_title = $requestData['arabic_banner_sub_title'] ?? '';
    
        
        if ($popularAttraction->save()) {
            return redirect()->route('popular-attraction.index')->with('success', 'Popular Attraction updated successfully');
        } else {
            return redirect()->back()->with('error', 'Error updating Popular Attractions');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function  deletePopularAttraction($id)
    {
        
        $popularAttraction = PopularAttraction::find($id);
    
        
        if (!$popularAttraction) {
            return redirect()->route('popular-attraction.index')->with('error', 'PopularAttraction not found');
        }
    
        $url = URL::previous();
        if ($popularAttraction->delete()) {
         
            return redirect()->to($url)->with('success','Popular Attraction deleted successfully');
        } else {
            return redirect()->to($url)->with('error', 'Error deleting Popular Attraction');
   
        }
    }
}
