<?php

namespace App\Http\Controllers\Admin\SeoLinks;

use App\Models\Setting;
use App\Models\PopularGuide;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;

class PopularGuideController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title'] = "PopularGuides";
        $header['heading'] = "PopularGuides";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'name' => (request()->input('name') != NULL) ? request()->input('name') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('name') != NULL) {
            $appliedFilter['where'][] = ['name', '=', request()->input('name')];
        }

        if (request()->input('status') != NULL) {
            $appliedFilter['where'][] = ['status', '=', request()->input('status')];
        }

        $popularGuideDataList = PopularGuide::getPopularGuides($appliedFilter);
        $popularGuideDataCount = PopularGuide::count();

        $popularGuideData = $popularGuideDataList['data'];
        if ($popularGuideData['status'] == 1) {
            return view('admin/popular-guide/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'popularGuideCount' => $popularGuideDataCount, 'popularGuideData' => $popularGuideData, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/popular-guide/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'popularGuideData' => $popularGuideData, 'popularGuideDataCount' => $popularGuideDataCount, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "PopularGuides- Add";
        $header['heading'] = "PopularGuides - Add";


        return view('admin/popular-guide/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only([
            'name',
            'popular_url',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'popular_url' => 'required | url',
            'status' => 'required',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);
        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $newFileName = $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        }

        $popularGuide = PopularGuide::create(
            [
                'name' => $requestData['name'],
                'url' => $requestData['popular_url'],
                'status' => $requestData['status'],
                'content' => $requestData['content'] ?? '',
                'arabic_content' => $requestData['arabic_content'],
                'title' => $requestData['title'] ?? '',
                'arabic_title' => $requestData['arabic_title'] ?? '',
                'sub_title' => $requestData['sub_title'] ?? '',
                'arabic_sub_title' => $requestData['arabic_sub_title'] ?? '',
                'banner_title' => $requestData['banner_title'] ?? '',
                'arabic_banner_title' => $requestData['arabic_banner_title'] ?? '',
                'banner' => $newFileName ?? '',
                'banner_sub_title' => $requestData['banner_sub_title'] ?? '',
                'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'] ?? '',

            ]
        );
        if ($popularGuide) {
            return redirect()->route('popular-guide.index')->with('success', 'Popular Guide Created Successully');
        } else {
            return redirect()->back()->with('error','Error Creating Popular Guide');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "PopularGuides - View";
        $header['heading'] = "PopularGuides - View";
    
       
        $popularGuideDetails = PopularGuide::where('id', $id)->get();
    
       
        if (!$popularGuideDetails->isEmpty()) {
           
            return view('admin/popular-guide/view')->with([
                'header' => $header,
                'popularGuideDetails' => $popularGuideDetails->first(), 
            ]);
        } else {
            return redirect()->route('popular-guide.index')->with('error', 'Error');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "PopularGuides - Edit";
        $header['heading'] = "PopularGuides - Edit";
    
      
        $popularGuideDetails  =PopularGuide::where('id', $id)->get();
    
     
        if (!$popularGuideDetails ->isEmpty()) {
       
            return view('admin/popular-guide/update')->with([
                'header' => $header,
                'popularGuideDetails' => $popularGuideDetails ->first(), 
            ]);
        } else {
            return redirect()->route('popular-guide.index')->with('error', 'Error');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $requestData = $request->only([
            'name',
            'popular_url',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'popular_url' => 'required | url',
            'status' => 'required',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];
    
      
        $this->validate($request, $rules);
    
      
        $popularGuide = PopularGuide::find($id);
    
       
        if (! $popularGuide) {
            return redirect()->route('popular-guide.index')->with('error', 'Popular Guides not found');
        }
    
        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $popularGuide->banner= $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        }
      
        $popularGuide->name = $requestData['name'];
        $popularGuide->url = $requestData['popular_url'];
        $popularGuide->status = $requestData['status'];
        $popularGuide->content = $requestData['content'] ?? '';
        $popularGuide->arabic_content = $requestData['arabic_content'];
        $popularGuide->title = $requestData['title'] ?? '';
        $popularGuide->arabic_title = $requestData['arabic_title'] ?? '';
        $popularGuide->sub_title = $requestData['sub_title'] ?? '';
        $popularGuide->arabic_sub_title = $requestData['arabic_sub_title'] ?? '';
        $popularGuide->banner_title = $requestData['banner_title'] ?? '';
        $popularGuide->arabic_banner_title = $requestData['arabic_banner_title'] ?? '';
        $popularGuide->banner_sub_title = $requestData['banner_sub_title'] ?? '';
        $popularGuide->arabic_banner_sub_title = $requestData['arabic_banner_sub_title'] ?? '';
    
        
        if ($popularGuide->save()) {
            return redirect()->route('popular-guide.index')->with('success', 'Popular Guide updated successfully');
        } else {
            return redirect()->back()->with('error', 'Error updating PopularGuides');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function  deletePopularGuide($id)
    {
        
        $popularGuide = PopularGuide::find($id);
    
        
        if (!$popularGuide) {
            return redirect()->route('popular-guide.index')->with('error', 'Popular Guide not found');
        }
    
        $url = URL::previous();
        if ($popularGuide->delete()) {
         
            return redirect()->to($url)->with('success','Popular Guide deleted successfully');
        } else {
            return redirect()->to($url)->with('error', 'Error deleting Popular Guide');
   
        }
    }
}
