<?php

namespace App\Http\Controllers\Admin\SeoLinks;

use App\Models\Setting;
use Illuminate\Http\Request;
use App\Models\PopularTravel;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class PopularTravelController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title'] = "Popular Travels";
        $header['heading'] = "Popular Travels";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'name' => (request()->input('name') != NULL) ? request()->input('name') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('name') != NULL) {
            $appliedFilter['where'][] = ['name', '=', request()->input('name')];
        }

        if (request()->input('status') != NULL) {
            $appliedFilter['where'][] = ['status', '=', request()->input('status')];
        }

        $popularTravelDataList = PopularTravel::getPopularTravels($appliedFilter);
        $popularTravelDataCount = PopularTravel::count();

        $popularTravelData = $popularTravelDataList['data'];
        if ($popularTravelData['status'] == 1) {
            return view('admin/popular-travel/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'popularTravelCount' => $popularTravelDataCount, 'popularTravel' => $popularTravelData, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/popular-travel/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'popularTravelData' => $popularTravelData, 'popularTravelCount' => $popularTravelDataCount, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "Popular Travels- Add";
        $header['heading'] = "Popular Travels - Add";


        return view('admin/popular-travel/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only([
            'name',
            'popular_url',
            'travel_thumbnail',
            'travel_price',
            'status',
            'country_code',
            'city'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'popular_url' => 'required | url',
            'travel_thumbnail'=> 'required ',
            'travel_price'=> 'required | integer',
            'status' => 'required',
            'country_code' => 'required',
            'city' => 'required',
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        if ($request->hasFile('travel_thumbnail')) {
            $imagePath = $request->file('travel_thumbnail')->store('popular_travel_thumbnails', 'public');
            
        }

        $popularTravel = PopularTravel::create(
            [
                'name' => $requestData['name'],
                'url' => $requestData['popular_url'],
                'thumbnail' => $imagePath,
                'price' => $requestData['travel_price'],
                'status' => $requestData['status'],
                'country_code' => $requestData['country_code'],
                'city_code' => $requestData['city']

            ]
        );
        if ($popularTravel) {
            return redirect()->route('popular-travel.index')->with('success', 'Popular Travel Created Successully');
        } else {
            return redirect()->back()->with('error','Error Creating Popular Travel');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "Popular Travels - View";
        $header['heading'] = "Popular Travels - View";
    
       
        $popularTravelDetails = PopularTravel::where('id', $id)->get();
    
       
        if (!$popularTravelDetails->isEmpty()) {
           
            return view('admin/popular-travel/view')->with([
                'header' => $header,
                'popularTravelDetails' => $popularTravelDetails->first(), 
            ]);
        } else {
            return redirect()->route('popular-travel.index')->with('error', 'Error');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        
        $header['title'] = "Popular Travels - Edit";
        $header['heading'] = "Popular Travels - Edit";
    
      
        $popularTravelDetails=PopularTravel::where('id', $id)->get();
    
     
        if (!$popularTravelDetails ->isEmpty()) {
       
            return view('admin/popular-travel/update')->with([
                'header' => $header,
                'popularTravelDetails' => $popularTravelDetails ->first(), 
            ]);
        } else {
            return redirect()->route('popular-travel.index')->with('error', 'Error');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $requestData = $request->only([
            'name',
            'popular_url',
            'travel_thumbnail',
            'travel_price',
            'status',
            'country_code',
            'city'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'popular_url' => 'required | url',
            
            'travel_price'=> 'required | integer',
            'status' => 'required',
            'country_code' => 'required',
            'city' => 'required',
        ];
      
        $this->validate($request, $rules);
    
      
        $popularTravel = PopularTravel::find($id);
    
       
        if (! $popularTravel) {
            return redirect()->route('popular-travel.index')->with('error', 'Popular Travels not found');
        }
    
      
        $popularTravel->name = $requestData['name'];
        $popularTravel->url = $requestData['popular_url'];
        $popularTravel->url = $requestData['popular_url'];
        $popularTravel->price = $requestData['travel_price'];
        $popularTravel->status = $requestData['status'];
        $popularTravel->country_code = $requestData['country_code'];
        $popularTravel->city_code = $requestData['city'];        

        if ($request->hasFile('travel_thumbnail')) {
            $imagePath = $request->file('travel_thumbnail')->store('popular_travel_thumbnails', 'public');
            $popularTravel->thumbnail = $imagePath;
        }
    
        
        if ($popularTravel->save()) {
            return redirect()->route('popular-travel.index')->with('success', 'Popular Travel updated successfully');
        } else {
            return redirect()->back()->with('error', 'Error updating Popular Travels');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function  deletePopularTravel($id)
    {
        
        $popularTravel = PopularTravel::find($id);
    
        
        if (!$popularTravel) {
            return redirect()->route('popular-travel.index')->with('error', 'Popular Travel not found');
        }
    
        $url = URL::previous();
        if ($popularTravel->delete()) {
         
            return redirect()->to($url)->with('success','Popular Travel deleted successfully');
        } else {
            return redirect()->to($url)->with('error', 'Error deleting Popular Travel');
   
        }
    }
}
