<?php

namespace App\Http\Controllers\Admin\SeoLinks;

use App\Models\Setting;
use App\Models\RehlteLink;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;

class RehlteLinkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title'] = "Rehlte Links";
        $header['heading'] = "Rehlte Links";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'name' => (request()->input('name') != NULL) ? request()->input('name') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('name') != NULL) {
            $appliedFilter['where'][] = ['name', '=', request()->input('name')];
        }

        if (request()->input('status') != NULL) {
            $appliedFilter['where'][] = ['status', '=', request()->input('status')];
        }

        $rehlteLinkDataList = RehlteLink::getRehlteLinks($appliedFilter);
        $rehlteLinkDataCount = RehlteLink::count();

        $rehlteLinkData = $rehlteLinkDataList['data'];
        if ($rehlteLinkData['status'] == 1) {
            return view('admin/rehlte-links/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'rehlteLinkCount' => $rehlteLinkDataCount, 'rehlteLinkData' => $rehlteLinkData, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/rehlte-links/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'rehlteLinkData' => $rehlteLinkData, 'rehlteLinkDataCount' => $rehlteLinkDataCount, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "Rehlte Links- Add";
        $header['heading'] = "Rehlte Links - Add";


        return view('admin/rehlte-links/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only([
            'name',
            'popular_url',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'popular_url' => 'required | url',
            'status' => 'required',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);
        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $newFileName = $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        }

        $rehlteLink = RehlteLink::create(
            [
                'name' => $requestData['name'],
                'url' => $requestData['popular_url'],
                'status' => $requestData['status'],
                'content' => $requestData['content'] ?? '',
                'arabic_content' => $requestData['arabic_content'],
                'title' => $requestData['title'] ?? '',
                'arabic_title' => $requestData['arabic_title'] ?? '',
                'sub_title' => $requestData['sub_title'] ?? '',
                'arabic_sub_title' => $requestData['arabic_sub_title'] ?? '',
                'banner_title' => $requestData['banner_title'] ?? '',
                'arabic_banner_title' => $requestData['arabic_banner_title'] ?? '',
                'banner' => $newFileName ?? '',
                'banner_sub_title' => $requestData['banner_sub_title'] ?? '',
                'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'] ?? '',

            ]
        );
        if ($rehlteLink) {
            return redirect()->route('rehlte-links.index')->with('success', 'Rehlte Link Created Successully');
        } else {
            return redirect()->back()->with('error','Error Creating Rehlte Link');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "Rehlte Links - View";
        $header['heading'] = "Rehlte Links - View";
    
       
        $rehlteLinkDetails = RehlteLink::where('id', $id)->get();
    
       
        if (!$rehlteLinkDetails->isEmpty()) {
           
            return view('admin/rehlte-links/view')->with([
                'header' => $header,
                'rehlteLinkDetails' => $rehlteLinkDetails->first(), 
            ]);
        } else {
            return redirect()->route('rehlte-links.index')->with('error', 'Error');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "Rehlte Links - Edit";
        $header['heading'] = "Rehlte Links - Edit";
    
      
        $rehlteLinkDetails  =RehlteLink::where('id', $id)->get();
    
     
        if (!$rehlteLinkDetails ->isEmpty()) {
       
            return view('admin/rehlte-links/update')->with([
                'header' => $header,
                'rehlteLinkDetails' => $rehlteLinkDetails ->first(), 
            ]);
        } else {
            return redirect()->route('rehlte-links.index')->with('error', 'Error');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $requestData = $request->only([
            'name',
            'popular_url',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'popular_url' => 'required | url',
            'status' => 'required',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];
    
      
        $this->validate($request, $rules);
    
      
        $rehlteLink = RehlteLink::find($id);
    
       
        if (! $rehlteLink) {
            return redirect()->route('rehlte-links.index')->with('error', 'Rehlte Links not found');
        }
    
        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $rehlteLink->banner= $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        }
      
        $rehlteLink->name = $requestData['name'];
        $rehlteLink->url = $requestData['popular_url'];
        $rehlteLink->status = $requestData['status'];
        $rehlteLink->content = $requestData['content'] ?? '';
        $rehlteLink->arabic_content = $requestData['arabic_content'];
        $rehlteLink->title = $requestData['title'] ?? '';
        $rehlteLink->arabic_title = $requestData['arabic_title'] ?? '';
        $rehlteLink->sub_title = $requestData['sub_title'] ?? '';
        $rehlteLink->arabic_sub_title = $requestData['arabic_sub_title'] ?? '';
        $rehlteLink->banner_title = $requestData['banner_title'] ?? '';
        $rehlteLink->arabic_banner_title = $requestData['arabic_banner_title'] ?? '';
        $rehlteLink->banner_sub_title = $requestData['banner_sub_title'] ?? '';
        $rehlteLink->arabic_banner_sub_title = $requestData['arabic_banner_sub_title'] ?? '';
    
        
        if ($rehlteLink->save()) {
            return redirect()->route('rehlte-links.index')->with('success', 'Rehlte Link updated successfully');
        } else {
            return redirect()->back()->with('error', 'Error updating Rehlte Links');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function  deleteRehlteLinks($id)
    {
        
        $rehlteLink = RehlteLink::find($id);
    
        
        if (!$rehlteLink) {
            return redirect()->route('rehlte-links.index')->with('error', 'Rehlte Link not found');
        }
    
        $url = URL::previous();
        if ($rehlteLink->delete()) {
         
            return redirect()->to($url)->with('success','Rehlte Link deleted successfully');
        } else {
            return redirect()->to($url)->with('error', 'Error deleting Rehlte Link');
   
        }
    }
}
