<?php

/**
 * @package     TrendingHotels
 * @subpackage   TrendingHotels
 * @Copyright(C) 2023 [Travel Portal].
 * @Version 1.0.0
 * module of the  TrendingHotels.
 */

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Carbon;
use App\Models\Setting;
use App\Models\City;
use App\Models\SeoTrendingHotel;
use App\Traits\CommonService;
use DB;

class SeoTrendingHotelsController extends Controller
{
    use CommonService;

    /**
     * Display a listing of the markups.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title']="SEO Trending Hotel List";
        $header['heading']="SEO Trending Hotel List";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'destination' => (request()->input('destination') != NULL) ? request()->input('destination') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('origin') != NULL) {
            $appliedFilter['where'][] = ['origin', '=', request()->input('origin')];
        }

        if (request()->input('destination') != NULL) {
            $appliedFilter['where'][] = ['destination', '=', request()->input('destination')];
        }

        $trendingHotelDataList = SeoTrendingHotel::getSeoTrendingHotels($appliedFilter);
        $trendingHotelDataCount = SeoTrendingHotel::count();

        $trendingHotelData = $trendingHotelDataList['data'];
        if ($trendingHotelDataCount > 0) {
            //$trendingHotelData->data = $trendingHotelData->data->toArray();
            //echo "<pre>"; print_r($trendingHotelData); die;
            // foreach ($trendingHotelData as $key => &$trendingHotel) {
            //     $trendingHotel->from_airport = str_replace(',', ', ', $trendingHotel->from_airports);
            //     $trendingHotel->to_airports = str_replace(',', ', ', $trendingHotel->to_airports);
            //     $trendingHotel->period = date('d-M-Y', strtotime($trendingHotel->from_date)).' to '.date('d-M-Y', strtotime($trendingHotel->to_date));
            //     //echo "<pre>"; print_r($trendingHotel); die;
            // }
        }
        if ($trendingHotelData['status'] == 1) {
            return view('admin/seo-trending-hotel/index')->with(['header'=>$header, 'appliedFilter'=>$appliedFilter, 'trendingHotelDataCount'=>$trendingHotelDataCount, 'trendingHotelData'=>$trendingHotelData,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/seo-trending-hotel/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter, 'trendingHotelData'=>$trendingHotelData,'trendingHotelDataCount'=>$trendingHotelDataCount,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    public function getCities() {
        $result = City::select('cities.id', 'cities.latitude', 'cities.longitude', 'city_i18ns.city_name', 'city_i18ns.language_code')
            ->leftJoin("city_i18ns", "city_i18ns.city_id", "=", "cities.id")
            ->where('cities.status', '=', 'active')
            ->orderBy('city_name', 'asc')
            ->get()
            ->toArray();

        $cities = [];
        foreach ($result as $city) {
            $cityKey = 'city_'.$city['language_code'];
            if (isset($cities[$city['id']]) == false) {
                $city[$cityKey] = $city['city_name'];
                $cities[$city['id']] = $city;
            } else {
                $cities[$city['id']][$cityKey] = $city['city_name'];
            }
        }
        return $cities;
    }


    /**
     * Show the form for creating a new markups.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "SEO Trending Hotel - Add";
        $header['heading'] = "SEO Trending Hotel - Add";

        $cities = $this->getCities();

        return view('admin/seo-trending-hotel/add')->with(['header' => $header, 'cities' => $cities]);
    }

    /**
     * Store a newly created markups in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only([
            'city',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title',
        ]);

        $rules = [
            'city' => 'required',
            'content' => 'required',
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);
        $cities = $this->getCities();
        $cityId = $requestData['city'];
        $requestData = [
            'city_en' => $cities[$cityId]['city_en'],
            'city_ar' => $cities[$cityId]['city_ar'],
            'status' => $requestData['status'],
            'content' => $requestData['content'],
            'arabic_content' => $requestData['arabic_content'],
            'title' => $requestData['title'],
            'arabic_title' => $requestData['arabic_title'],
            'sub_title' => $requestData['sub_title'],
            'arabic_sub_title' => $requestData['arabic_sub_title'],
            'banner_title' => $requestData['banner_title'],
            'arabic_banner_title' => $requestData['arabic_banner_title'],
            'upload_banner' => $requestData['upload_banner'],
            'banner_sub_title' => $requestData['banner_sub_title'],
            'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'],
        ];

        $response = SeoTrendingHotel::createSeoTrendingHotel($requestData);
        if (!empty($response['data'])) {
            return redirect()->route('seo-trending-hotel.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->back()->with('error', $response['message']);
        }
    }

    /**
     * Display the specified markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "Trending Hotel - View";
        $header['heading'] = "Trending Hotel - View";

        $filter = array(
            'id' => $id
        );

        $response = SeoTrendingHotel::getSeoTrendingHotels($filter);
        if ($response['status'] == 1 && !empty($response['data'])) {
            $trendingHotelDetails = $response['data']->toArray();
            return view('admin/seo-trending-hotel/view')->with(['header' => $header, 'trendingHotelDetails' => $trendingHotelDetails]);
        } else {
            return redirect()->route('seo-trending-hotel.index')->with('error', $response['message']);
        }
    }

    /**
     * Show the form for editing the specified markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "SEO Trending Hotel - Edit";
        $header['heading'] = "SEO Trending Hotel - Edit";

        $filter = array(
            'id' => $id
        );

        $response = SeoTrendingHotel::getSeoTrendingHotels($filter);

        $cities = $this->getCities();

        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/seo-trending-hotel/edit')->with(['header' => $header, 'trendingHotelDetails' => $response['data'], 'cities' => $cities]);
        } else {
            return redirect()->to('seo-trending-hotel.index')->with('error', $response['message']);
        }
    }

    /**
     * Update the specified markups in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $requestData = $request->only([
            'id',
            'city',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title',
        ]);



        $rules = [];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $cities = $this->getCities();
        $cityId = $requestData['city'];
        $requestData = [
            'id' => $requestData['id'],
            'city_en' => $cities[$cityId]['city_en'],
            'city_ar' => $cities[$cityId]['city_ar'],
            'status' => $requestData['status'],
            'content' => $requestData['content'],
             'arabic_content' => $requestData['arabic_content'],
            'title' => $requestData['title'],
            'arabic_title' => $requestData['arabic_title'],
            'sub_title' => $requestData['sub_title'],
            'arabic_sub_title' => $requestData['arabic_sub_title'],
            'banner_title' => $requestData['banner_title'],
            'arabic_banner_title' => $requestData['arabic_banner_title'],
            'upload_banner' => $requestData['upload_banner']?? '',
            'banner_sub_title' => $requestData['banner_sub_title'],
            'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'],
        ];

        // dd($requestData);

        $response = SeoTrendingHotel::updateSeoTrendingHotel($requestData);

        if ($response['status'] == 1 &&  !empty($response['data'])) {
            return redirect()->route('seo-trending-hotel.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->route('seo-trending-hotel.index', $response)->with('error', $response['message']);

        }
    }

    /**
     * Remove the specified markups from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    /**
     * Display a listing of the markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function getListData() {
        $header['title']="SEO Trending Hotel List";
        $header['heading']="SEO Trending Hotel List";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'destination' => (request()->input('destination') != NULL) ? request()->input('destination') : '',
        );

        if (request()->input('origin') != NULL) {
            $appliedFilter['where'][] = ['origin', '=', request()->input('origin')];
        }

        if (request()->input('destination') != NULL) {
            $appliedFilter['where'][] = ['destination', '=', request()->input('destination')];
        }

        $trendingHotelDataList = SeoTrendingHotel::getSeoTrendingHotels($appliedFilter);
        $trendingHotelDataCount = SeoTrendingHotel::count();
        $trendingHotelData = $trendingHotelDataList['data'];
        if ($trendingHotelData['status'] == 1) {
            return view('admin/seo-trending-hotel/index')->with(['header'=>$header, 'appliedFilter'=>$appliedFilter, 'trendingHotelDataCount'=>$trendingHotelDataCount, 'trendingHotelData'=>$trendingHotelData,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/seo-trending-hotel/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter, 'trendingHotelData'=>$trendingHotelData,'trendingHotelDataCount'=>$trendingHotelDataCount,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Remove the specified markups from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteSeoTrendingHotel($id)
    {
        if(!hasPermission('TrendingHotels','delete')){
            return view('admin/401');
        }
        $url = URL::previous();

        $response = SeoTrendingHotel::deleteSeoTrendingHotel($id);

        if ($response['status'] == 1) {
            return redirect()->to($url)->with('success', $response['message']);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }

}

