<?php


/**
 * @package     Dashboard
 * @subpackage   Summer Offers
 * @Author      Amar Technolabs Pvt. ltd(info@amarinfotech.com)
 * @Copyright(C) 2023 [Travel Portal].
 * @Version 1.0.0
 * module of the  Dashboard.
 */

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\Setting;
use App\Models\SummerOffer;
use App\Traits\EmailService;
use Carbon\Carbon;

class SummerOfferController extends Controller
{
    use EmailService;
    /**
     * Display a listing of the Summer Offers.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $header['title'] = "Summer Offers";
        $header['heading'] = "Summer Offers";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $filter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );
        if (request()->input('offer_title') != NULL) {
            $offerTitle = request()->input('offer_title');
            $filter['where'][] = [
                DB::raw("offer_title"),
                'LIKE',
                '%' . $offerTitle . '%'
            ];
        }
        if (request()->input('status') != NULL) {
            $filter['where'][] = ['status', '=', request()->input('status')];
        }
        $summerOffersDataList = SummerOffer::getSummerOffers($filter);
        $summerOffersData = $summerOffersDataList['data'];
        if ($summerOffersData['status'] == 1) {
            return view('admin/summer-offers/index')->with(['header' => $header, 'summerOffersData' => $summerOffersData, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter,  'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        } else {
            return view('admin/summer-offers/index')->with(['header' => $header, 'summerOffersData' => $summerOffersData, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter, 'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new summer offer
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        if (!hasPermission('CUSTOMERS_LIST', 'create')) {
            return view('admin/401');
        }
        $summerOfferId = $request->id;
        $header['title'] = 'Add Summer Offer';

        return view('admin/summer-offers/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created summer offers in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->all();
        $response = SummerOffer::createSummerOffer($requestData);
        if (!empty($response['data'])) {
            return redirect()->route('summer-offers.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->back()->with('error', $response['message']);
        }
    }

    /**
     * Display the specified summer offer.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (!hasPermission('TRAVELLER_LIST', 'read')) {
            return view('admin/401');
        }
        $header['title'] = 'View Summer Offer';
        $header['heading'] = 'View Summer Offer';
        $filter = array(
            'id' => $id
        );
        $response = SummerOffer::getSummerOffers($filter);
        $summerOfferDetails = $response['data'];
        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/summer-offers/view')->with(['header' => $header, 'summerOfferDetails' => $summerOfferDetails]);
        } else {
            return redirect()->route('summer-offers.index')->with('error', $response['message']);
        }
    }

    /**
     * Show the form for editing the specified summer offer.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!hasPermission('CUSTOMERS_LIST', 'update')) {
            return view('admin/401');
        }
        $header['title'] = 'Edit Summer Offer';
        $header['heading'] = 'Edit Summer Offer';
        $header['method'] = 'Edit';

        $filter = array(
            'id' => $id
        );
        $response = SummerOffer::getSummerOffers($filter);
        $summerOfferDetail = $response['data'];
        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/summer-offers/update')->with(['header' => $header, 'summerOfferDetail' => $summerOfferDetail]);
        } else {
            return redirect()->route('summer-offers.index')->with('error', $response['message']);
        }
    }

    /**
     * Update the specified summer offer in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $url = $request->redirects_to;
        $requestData = $request->all();

        $rules = [];
        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $response = SummerOffer::updateSummerOffer($requestData);

        if (!empty($response['data'])) {
            return redirect()->route('summer-offers.index', compact('id'))->with('success', $response['message']);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }

    /**
     * Remove the specified travellers from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteSummerOffer($summerOfferID)
    {

        $url = URL::previous();
        $response = SummerOffer::deleteSummerOffer($summerOfferID);
        $message = $response['message'] . '</br>';

        if ($response['status'] == 1) {
            return redirect()->to($url)->with('success', $message);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }
}
