<?php

namespace App\Http\Controllers\Admin\Templates;

use App\Enums\Locale;
use App\Models\User;
use App\Models\Setting;
use App\Models\Customer;
use App\Models\MailCampaign;
use App\Traits\EmailService;
use Illuminate\Http\Request;
use App\Models\MailCampaignI18ns;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\CampaignEmailsImport;

class MailCampaignController extends Controller
{
    use EmailService;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!hasPermission('MAIL_TEMPLATES', 'read')) {
            return view('admin/401');
        }

        $header['title'] = "Mail Campaign";
        $header['heading'] = "Mail Campaign";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $filter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'id',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'name' => (request()->input('name') != NULL) ? request()->input('name') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('name') != NULL) {
            $filter['whereHas'][] = ['name', 'like', '%' . request()->input('name') . '%'];
        }

        $mailCampaignDataList = MailCampaign::getMailCampaignData($filter);
        $mailCampaignCountData = MailCampaign::count();
        $mailCampaignData = $mailCampaignDataList['data'];

        if ($mailCampaignDataList['status'] == 1) {
            return view('admin/templates/mail-campaign/index')->with(['header' => $header, 'mailCampaignData' => $mailCampaignData, 'mailCampaignCountData' => $mailCampaignCountData, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter,  'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        } else {
            return view('admin/templates/mail-campaign/index')->with(['header' => $header, 'mailCampaignData' => $mailCampaignData, 'mailCampaignCountData' => $mailCampaignCountData, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter, 'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!hasPermission('MAIL_TEMPLATES', 'update')) {
            return view('admin/401');
        }
        $header['title'] = 'Mail Campaign - Add';
        $header['method'] = 'Add';


        return view('admin/templates/mail-campaign/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!hasPermission('MAIL_TEMPLATES', 'update')) {
            return view('admin/401');
        }
        $url = $request->only('redirects_to');
        $requestData = $request->all();

        $rules = [];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);
        $response = MailCampaign::createMailCampaign($requestData);

        if (!empty($response['data'])) {
            return redirect()->to($url['redirects_to'])->with('success', $response['message']);
        } else {
            return redirect()->to($url['redirects_to'])->with('error', $response['message']);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) //Send Email
    {
        if (!hasPermission('MAIL_TEMPLATES', 'update')) {
            return view('admin/401');
        }
        $header['title'] = 'Mail Campaign - Send Mail';
        $header['method'] = 'Send Mail';
        $filter = array(
            'id' => $id,
        );
        $getUser = User::all();
        $response = MailCampaign::getMailCampaignData($filter);
        $mailCampaignDetail = $response['data'];

        $userEmail = Customer::pluck('email');

        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/templates/mail-campaign/send-mail')->with(['header' => $header, 'getUser' => $getUser, 'mailCampaignDetail' => $mailCampaignDetail, 'userEmail' => $userEmail]);
        } else {
            return redirect()->route('mail-campaign.index')->with('error', $response['message']);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!hasPermission('MAIL_TEMPLATES', 'update')) {
            return view('admin/401');
        }
        $header['title'] = 'Mail Campaign - Edit';
        $header['method'] = 'Edit';
        $filter = array(
            'id' => $id,
        );
        $getUser = User::all();
        $response = MailCampaign::getMailCampaignData($filter);
        $mailCampaignDetail = $response['data'];

        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/templates/mail-campaign/update')->with(['header' => $header, 'getUser' => $getUser, 'mailCampaignDetail' => $mailCampaignDetail]);
        } else {
            return redirect()->route('mail-campaign.index')->with('error', $response['message']);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!hasPermission('MAIL_TEMPLATES', 'update')) {
            return view('admin/401');
        }
        $url = $request->only('redirects_to');
        $requestData = $request->all();

        $rules = [];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);
        $response = MailCampaign::updateMailCampaign($requestData);

        if (!empty($response['data'])) {
            return redirect()->to($url['redirects_to'])->with('success', $response['message']);
        } else {
            return redirect()->to($url['redirects_to'])->with('error', $response['message']);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function  deleteMailCampaign($id)
    {

        $mailCampaign = MailCampaign::find($id);
        $mailCampaigni18s = MailCampaignI18ns::where('mail_id', $id);


        if (!$mailCampaign && !$mailCampaigni18s) {
            return redirect()->route('mail-campaign.index')->with('error', 'Mail Campaign not found');
        }

        $url = URL::previous();
        if ($mailCampaign->delete() && $mailCampaigni18s->delete()) {

            return redirect()->to($url)->with('success', 'Mail Campaign deleted successfully');
        } else {
            return redirect()->to($url)->with('error', 'Error deleting Mail Campaign');
        }
    }



    public function uploadMailFile(Request $request)
    {
        $request->validate([
            'file' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $imageName = time() . '.' . $request->file->extension();
        $request->file->move(storage_path('app/public/template_images'), $imageName);

        chmod(storage_path("app/public/template_images/{$imageName}"), 0777);

        if (file_exists(storage_path("app/public/template_images/{$imageName}"))) {
            return response()->json(['location' => '/storage/template_images/' . $imageName]);
        } else {
            return response()->json(['error' => 'File upload failed'], 500);
        }
    }



    public function sendMailCampaign(Request $request)
    {
        $request->validate([
            'mail_template_id' => 'required|string',
            'customer_email' => 'array',
            'customer_email_excel' => 'nullable|mimes:xlsx,xls',
        ]);


        try {

            if (!$request->customer_email_excel && !$request->customer_email) {
                return redirect()->back()->with('error', 'Please select at least one customer email or import from excel file');
            }

            // Retrieve email content for both languages
            $mailContents = MailCampaignI18ns::where('mail_id', $request->mail_template_id)->get();

            if ($mailContents->isEmpty()) {
                return redirect()->back()->with('error', 'Mail content not found');
            }

            $files = [];
            if ($request->hasFile('customer_email_excel')) {
                $preferredLanguage = Locale::English->value;
                $mailContent = $mailContents->firstWhere('language_code', $preferredLanguage)
                            ?? $mailContents->firstWhere('language_code', Locale::English->value)
                            ?? $mailContents->first();
        
                Excel::import(new CampaignEmailsImport($mailContents), $request->file('customer_email_excel'));
        
                return redirect()->route('mail-campaign.index')->with('success', 'Emails are being processed in the background!');
            }
            
        
               
            
            // Get recipient emails
            if (in_array("All", $request->customer_email)) {
                $emails = Customer::whereNotNull('email')->where('email', '!=', '')->pluck('email')->toArray();
            } else {
                $emails = array_filter($request->customer_email);
            }

            foreach ($emails as $email) {

                $customer = Customer::where('email', $email)->first();
                $preferredLanguage = $customer->user_language ?? Locale::English->value;


                $mailContent = $mailContents->firstWhere('language_code', $preferredLanguage)
                    ?? $mailContents->firstWhere('language_code', Locale::English->value)
                    ?? $mailContents->first();

                $subject = $mailContent->subject ?? 'No Subject';
                $mailData = $mailContent->content ?? '<p>No Content Available</p>';


                Mail::send([], [], function ($message) use ($email, $subject, $mailData, $files) {
                    $message->to($email)
                        ->subject($subject)
                        ->setBody($mailData, 'text/html');
                });
            }

            return redirect()->route('mail-campaign.index')->with('success', 'Emails sent successfully');
            // return redirect()->back()->with('success', 'Emails sent successfully');

        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'An error occurred: ' . $e->getMessage());
        }
    }
}
