<?php


function amountToWords($number, $currency = 'SAR')
{
    $currencyMap = [
        'INR' => ['main' => 'Rupees', 'sub' => 'Paise'],
        'USD' => ['main' => 'Dollars', 'sub' => 'Cents'],
        'EUR' => ['main' => 'Euros', 'sub' => 'Cents'],
        'GBP' => ['main' => 'Pounds', 'sub' => 'Pence'],
        'AED' => ['main' => 'Dirhams', 'sub' => 'Fils'],
        'SAR' => ['main' => 'Riyals', 'sub' => 'Halalas'],
    ];

    $mainUnit = $currencyMap[$currency]['main'] ?? 'Rupees';
    $subUnit = $currencyMap[$currency]['sub'] ?? 'Paise';

    $no = (int)floor($number);
    $point = (int)round(($number - $no) * 100);

    $hundred = null;
    $digits_1 = strlen($no);
    $i = 0;
    $str = [];

    $words = [
        '0' => '', '1' => 'one', '2' => 'two', '3' => 'three',
        '4' => 'four', '5' => 'five', '6' => 'six', '7' => 'seven',
        '8' => 'eight', '9' => 'nine', '10' => 'ten', '11' => 'eleven',
        '12' => 'twelve', '13' => 'thirteen', '14' => 'fourteen',
        '15' => 'fifteen', '16' => 'sixteen', '17' => 'seventeen',
        '18' => 'eighteen', '19' => 'nineteen', '20' => 'twenty',
        '30' => 'thirty', '40' => 'forty', '50' => 'fifty',
        '60' => 'sixty', '70' => 'seventy', '80' => 'eighty',
        '90' => 'ninety'
    ];

    $digits = ['', 'hundred', 'thousand', 'lakh', 'crore'];

    while ($i < $digits_1) {
        $divider = ($i == 2) ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += ($divider == 10) ? 1 : 2;

        if ($number) {
            $plural = (count($str) && $number > 9) ? 's' : null;
            $hundred = (count($str) == 1 && $str[0]) ? ' and ' : null;
            $str [] = ($number < 21) ? $words[$number] . " " . $digits[count($str)] . $plural . " " . $hundred
                : $words[floor($number / 10) * 10] . " " . $words[$number % 10] . " " . $digits[count($str)] . $plural . " " . $hundred;
        } else {
            $str[] = null;
        }
    }

    $str = array_reverse($str);
    $result = implode('', $str);

    if ($point > 0) {
        if ($point > 20) {
            $points = $words[floor($point / 10) * 10] . " " . $words[$point % 10];
        } else {
            $points = $words[$point];
        }

        return ucwords(trim($result) . " $mainUnit and $points $subUnit Only");
    } else {
        return ucwords(trim($result) . " $mainUnit Only");
    }
}



?>