<?php

function getRandomString($length = 12) {
    $stringSpace = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $pieces = [];
    $max = mb_strlen($stringSpace, '8bit') - 1;
    for ($i = 0; $i < $length; ++ $i) {
        $pieces[] = $stringSpace[random_int(0, $max)];
    }
    return implode('', $pieces);
}
function getCreditCardType($cardNo) {
	/*
	'*CARD TYPES            *PREFIX           *WIDTH
	'American Express       34, 37            15
	'Diners Club            300 to 305, 36    14
	'Carte Blanche          38                14
	'Discover               6011              16
	'EnRoute                2014, 2149        15
	'JCB                    3                 16
	'JCB                    2131, 1800        15
	'Master Card            51 to 55          16
	'Visa                   4                 13, 16
	*/
	//Just in case nothing is found
	$creditCardType = "UNKNOWN";

	//Remove all spaces and dashes from the passed string
	$cardNo = str_replace("-", "",str_replace(" ", "",$cardNo));

	//Check that the minimum length of the string isn't less
	//than fourteen characters and -is- numeric
	If(strlen($cardNo) < 14 || !is_numeric($cardNo))
		return false;

	//Check the first two digits first
	switch(substr($cardNo,0, 2)) {
		case 34:
        case 37:
			$creditCardType = "AMEX";
			break;
		case 36:
			$creditCardType = "DINERS";
			break;
		case 38:
			$creditCardType = "Carte Blanche";
			break;
		case 51:
		case 52:
		case 53:
		case 54:
		case 55:
			$creditCardType = "MASTER";
			break;
	}

	//None of the above - so check the
	if($creditCardType == "UNKNOWN") {
		//first four digits collectively
		switch(substr($cardNo,0, 4)) {
			case 2014:
			case 2149:
				$creditCardType = "EnRoute";
				break;
			case 2131:
			case 1800:
				$creditCardType = "JCB";
				break;
			case 6011:
				$creditCardType = "DISCOVER";
				break;
		}
	}

	//None of the above - so check the
	if($creditCardType == "UNKNOWN") {
		//first three digits collectively
		if(substr($cardNo,0, 3) >= 300 && substr($cardNo,0, 3) <= 305) {
			$creditCardType = "American Diners Club";
		}
	}

	//None of the above -
	if($creditCardType == "UNKNOWN") {
		//So simply check the first digit
		switch(substr($cardNo,0, 1)) {
			case 3:
				$creditCardType = "JCB";
				break;
			case 4:
				$creditCardType = "VISA";
				break;
		}
	}

	return $creditCardType;
}

function getCreditCardExpiryData($cardExpiration) {
	$cardExpirationArray = explode("/", $cardExpiration);
	$result = [
		'month' => $cardExpirationArray[0],
		'year' => $cardExpirationArray[1]
	];
	if (strlen($cardExpirationArray[1]) == 2) {
		$result['year'] = '20'.$result['year'];
	}
	return $result;
}

function getMaskedCreditCard($number, $maskingCharacter = 'X') {
    return substr($number, 0, 4) . str_repeat($maskingCharacter, strlen($number) - 8) . substr($number, -4);
}
?>
