<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class AuthenticateApiKey
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        $origin = $request->headers->get('origin');  
        $referer = $request->headers->get('referer');

        $allowedOrigin = ['https://www.rehlte.com','https://rehlte.com','https://mobile.rehlte.com','https://demo.rehlte.com','https://demo.rehlte.com/', 'https://m.rehlte.com','https://api.rehlte.com','https://demoapi.rehlte.com', 'https://m.rehlte.com/','http://localhost:4200/','http://localhost:4200'];

        $isFromFrontend = false;
        if ($origin && in_array($origin, $allowedOrigin)) {
            $isFromFrontend = true;
        } elseif ($referer && in_array($referer, $allowedOrigin)) {
            $isFromFrontend = true;
        }

        if ($isFromFrontend && str_contains($response->headers->get('Content-Type'), 'application/json')) {        
                return  $response;
        }
        $response = [
            'success' => false,
            'data' => [],
            'message' => 'Unathenticated',
        ];

        return response()->json($response, 403);
    }
}
