<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ContentSecurityPolicy
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        $csp = "
            default-src 'self';
            script-src 'self' 'unsafe-inline' 'unsafe-eval'
                https://*.google.com https://*.googletagmanager.com https://*.google-analytics.com
                https://www.gstatic.com https://www.recaptcha.net
                https://cdn.jsdelivr.net https://cdnjs.cloudflare.com
                https://code.jquery.com https://cdn.datatables.net;
            style-src 'self' 'unsafe-inline'
                https://fonts.googleapis.com https://cdn.jsdelivr.net https://cdnjs.cloudflare.com
                https://cdn.datatables.net;
            img-src 'self' data: https://*;
            font-src 'self'
                https://fonts.gstatic.com https://cdn.jsdelivr.net https://cdnjs.cloudflare.com
                https://cdn.datatables.net;
            frame-src https://*.google.com https://www.gstatic.com https://www.recaptcha.net;
            connect-src 'self'
                " . env('APP_URL') . " https://*.google-analytics.com https://*.googletagmanager.com;
            object-src 'none';
            base-uri 'self';
            form-action 'self' " . env('WEBSITE_URL') . " https://uat.rehlte.com;
            upgrade-insecure-requests;
        ";

        // Remove unnecessary line breaks and multiple spaces
        $csp = preg_replace('/\s+/', ' ', trim($csp));

        $response->headers->set('Content-Security-Policy', $csp);

        return $response;
    }
}
