<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EncryptJsonResponse
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);


        $origin = $request->headers->get('origin');  
        $referer = $request->headers->get('referer');

        $allowedOrigin = ['https://uat.rehlte.com'];

        $isFromFrontend = false;
        if ($origin && in_array($origin, $allowedOrigin)) {
            $isFromFrontend = true;
        } elseif ($referer && in_array($referer, $allowedOrigin)) {
            $isFromFrontend = true;
        }

        if ($isFromFrontend && str_contains($response->headers->get('Content-Type'), 'application/json')) {
            $content = json_decode($response->getContent(), true);

            if (isset($content['data'])) {
                $plainText = json_encode($content['data']);
                $key = env('ENCRYPTION_SECRET_KEY');
                $iv = openssl_random_pseudo_bytes(16);

                $encrypted = openssl_encrypt($plainText, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $iv);

                $content['data'] = base64_encode($encrypted);
                $content['iv'] = base64_encode($iv);

                return response()->json($content, $response->getStatusCode());
            }
        }

        return $response;
    }
}
