<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;

class LocaleAndCurrencyMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $locale = $request->query('locale', config('app.locale')); 
        $currency = $request->query('currency', config('app.currency', 'SAR')); 

        App::setLocale($locale);

        Config::set('app.currency', $currency);

        app()->singleton('requestCurrency', function () use ($currency) {
            return $currency;
        });

        return $next($request);
    }
}
