<?php

namespace App\Imports;

use App\Models\HotelFacilityAr;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class HotelFacilityImport implements ToCollection, WithHeadingRow
{
    public $insertedCount = 0;
    public $skippedCount = 0;
    public $insertedItems = [];
    public $skippedItems = [];

    /**
     * @param Collection $rows
     */
    public function collection(Collection $rows)
    {
        foreach ($rows as $row) {
            $facilityNameEn = trim($row['facility_name_en'] ?? '');
            $facilityNameAr = trim($row['facility_name_ar'] ?? '');

            if (empty($facilityNameEn) || empty($facilityNameAr)) {
                continue;
            }

            if($facilityNameEn == 'Test Facility' || $facilityNameAr == 'مرفق الاختبار'){
                continue;
            }

            $exists = HotelFacilityAr::where('facility_name_en', $facilityNameEn)->where('facility_name_ar', $facilityNameAr)->exists();

            if (!$exists) {
                HotelFacilityAr::updateOrCreate(
                    [
                        'facility_name_en' => $facilityNameEn,
                    ],
                    [
                    'facility_name_en' => $facilityNameEn,
                    'facility_name_ar' => $facilityNameAr,
                ]);

                $this->insertedCount++;
                $this->insertedItems[] = $facilityNameEn;
            } else {
                $this->skippedCount++;
                $this->skippedItems[] = $facilityNameEn;
            }
        }
    }
}
