<?php

namespace App\Jobs;

use App\Models\Bookings;
use Illuminate\Bus\Queueable;
use App\Traits\BookingService;
use Illuminate\Support\Facades\DB;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class SendBookingEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, BookingService;

    public $refId;
    public $savedBookingDetails;

    /**
     * Create a new job instance.
     */
    public function __construct($savedBookingDetails, $refId)
    {
        $this->refId = $refId;
        $this->savedBookingDetails = $savedBookingDetails;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        DB::transaction(function () {
            $booking = Bookings::where('ref_id', $this->refId)
                ->where('booking_status', 'confirmed')
                ->where('email_notification', 0)
                ->lockForUpdate()
                ->first();

            if ($booking) {
                $isEmailSent = $this->sendBookingEmail($this->savedBookingDetails);
                if ($isEmailSent['success'] === true) {
                    $booking->update(['email_notification' => 1]);
                    sleep(2);
                }
            }
        }, 3);
    }
}
