<?php

namespace App\Jobs;

use App\Models\Bookings;
use Illuminate\Bus\Queueable;
use App\Traits\BookingService;
use Illuminate\Support\Facades\DB;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class SendBookingSmsJob  implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, BookingService;

    public $refId;
    public $savedBookingDetails;

    /**
     * Create a new job instance.
     */
    public function __construct($savedBookingDetails, $refId)
    {
        $this->refId = $refId;
        $this->savedBookingDetails = $savedBookingDetails;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        DB::transaction(function () {
            $booking = Bookings::where('ref_id', $this->refId)
                ->where('booking_status', 'confirmed')
                ->where('sms_notification', 0)
                ->lockForUpdate()
                ->first();

            if ($booking) {
                $isSmsSent = $this->sendBookingSms($this->savedBookingDetails);
                if ($isSmsSent) {
                    $booking->update(['sms_notification' => 1]);
                    sleep(2);
                }
            }
        }, 3);
    }
}
