<?php

namespace App\Jobs;

use App\Models\Bookings;
use Illuminate\Bus\Queueable;
use App\Traits\BookingService;
use Illuminate\Support\Facades\DB;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class SendBookingWhatsappJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, BookingService;

    public $refId;
    public $savedBookingDetails;

    /**
     * Create a new job instance.
     */
    public function __construct($savedBookingDetails, $refId)
    {
        $this->refId = $refId;
        $this->savedBookingDetails = $savedBookingDetails;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        DB::transaction(function () {
            $booking = Bookings::where('ref_id', $this->refId)
                ->where('booking_status', 'confirmed')
                ->where('whatsapp_notification', 0)
                ->lockForUpdate()
                ->first();

            if ($booking) {
                $iswhatsappSent = $this->sendBookingWhatsapp($this->savedBookingDetails);
                if ($iswhatsappSent) {
                    $booking->update(['whatsapp_notification' => 1]);
                    sleep(2);
                }
            }
        }, 3);
    }
}
