<?php

namespace App\Jobs;

use App\Enums\Locale;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Mail;

class SendCampaignMail implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $emailData;
    protected $mailContents;

    public function __construct($emailData, $mailContents)
    {
        $this->emailData = $emailData;
        $this->mailContents = $mailContents;
    }

    public function handle()
    {
        $preferredLanguage = Locale::English->value;

        $mailContent = $this->mailContents->firstWhere('language_code', $preferredLanguage)
            ?? $this->mailContents->firstWhere('language_code', Locale::English->value)
            ?? $this->mailContents->first();

        $subject = $mailContent->subject ?? 'No Subject';
        $mailData = $mailContent->content ?? '<p>No Content Available</p>';

        Mail::send([], [], function ($message) use ($subject, $mailData) {
            $message->to($this->emailData['email'], $this->emailData['name'])
                ->subject($subject)
                ->setBody($mailData, 'text/html');
        });
    }
}
