<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Storage;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Log;

class UpdateLangJsonFilesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $keys, $valueEnglish, $valueArabic;

    public function __construct(array $keys, array $valueEnglish, array $valueArabic)
    {
        $this->keys = $keys;
        $this->valueEnglish = $valueEnglish;
        $this->valueArabic = $valueArabic;
    }

    public function handle()
    {
        try {
            $path = storage_path('app/public/locale/b2c/');

            if (!is_dir($path)) {
                mkdir($path, 0777, true);
                chmod($path, 0777);
            }

            // Update English
            $enPath = $path . '/en.json';
            $existingEn = json_decode(Storage::disk('public')->get('locale/b2c/en.json'), true) ?? [];
            $mergedEn = array_merge($existingEn, array_combine($this->keys, $this->valueEnglish));
            file_put_contents($enPath, json_encode($mergedEn, JSON_UNESCAPED_UNICODE));

            // Update Arabic
            $arPath = $path . '/ar.json';
            $existingAr = json_decode(Storage::disk('public')->get('locale/b2c/ar.json'), true) ?? [];
            $mergedAr = array_merge($existingAr, array_combine($this->keys, $this->valueArabic));
            file_put_contents($arPath, json_encode($mergedAr, JSON_UNESCAPED_UNICODE));
        } catch (\Throwable $e) {
            Log::error('UpdateLangJsonFilesJob failed: ' . $e->getMessage(), [
                'trace' => $e->getTraceAsString(),
            ]);
        }
    }
}
