<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Laravel\Passport\HasApiTokens;
use App\Traits\Uuids;

class ApiLogin extends Authenticatable
{
    use HasFactory, HasApiTokens, Notifiable, Uuids;
    protected $table = "api_logins";
    protected $guarded = [];
    protected $fillable = ['type','name','password'];

    /**
     * insert new record in database
     */
    public static function createApiUserLogin($requestData)
    {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            $apiuserloginData = array(
                'id'  => $requestData['id'],
                'type'  => $requestData['type'],
                'name'  => $requestData['name'],
                'password'  => $requestData['password']
            );
            // save to table
            try {
                DB::beginTransaction();
                $apiLogin = ApiLogin::create($apiuserloginData);
                if ($apiLogin) {
                    $return['status'] = 1;
                    $return['message'] = 'Api user login records saved successfully';
                    $return['data'] = $apiLogin;
                }
                DB::commit();
            } catch (\Exception $e) {
               $return['message'] = 'Error during save record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
           $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }
}
