<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuids;
use Illuminate\Support\Facades\DB;

class BookingAdditionalDetail extends Model
{
    use HasFactory, Uuids;
    protected $table = 'booking_additional_details';
    protected $guarded = [];

    protected $fillable = ['booking_id', 'booking_details', 'service_provider_booking_request', 'service_provider_booking_response', 'service_provider_cancel_request', 'service_provider_cancel_response'];

    /**
     * insert new record in database
     */
    public static function createBookingAdditionalDetail($requestData) {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            DB::beginTransaction();
            
           

            $result = BookingAdditionalDetail::create($requestData);
            

            $return['status'] = 1;
            $return['message'] = 'Data saved successfully';
            $return['data'] = $result;

            DB::commit();
        } catch (\Exception $e) {
            $return['message'] = 'Error during save record : ' . $e->getMessage();
        }
        return $return;
    }

    /**
     * update record into database
     */
    public static function updateBookingAdditionalDetail($requestData) {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            DB::beginTransaction();
            $condition = ['booking_id' => $requestData['booking_id']];
            $result = BookingAdditionalDetail::updateOrCreate($condition, $requestData);

            $return['status'] = 1;
            $return['message'] = 'Data updated successfully';
            $return['data'] = $result;
            DB::commit();

        } catch (\Exception $e) {
            $return['message'] = 'Error during save record : ' . $e->getMessage();
        }
        return $return;
    }
}
