<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use App\Traits\Uuids;

class BookingCheckout extends Model
{
    use HasFactory, Uuids;
    protected $table = 'booking_checkout';
    protected $guarded = [];

    protected $fillable = ['ref_id', 'log_id', 'customer_id', 'payment_id', 'merchant_transaction_id', 'checkout_url', 'loyalty_points', 'booking_id', 'booking_ref_id', 'checkout_ids', 'initial_amount', 'amount', 'booking_type', 'booking_via', 'service_provider', 'supplier_id','supplier_name', 'ama_client_ref', 'booking_details'];

    /**
     * get list or single or all records to display
     */
    public static function getBookingCheckout($refId)
    {

        $return = array(
            'status' => false,
            'message' => 'something went wrong',
            'data' => []
        );
        $result = [];
        if ($refId != '') {
            try {
                $query = BookingCheckout::query();
                $query->select('booking_checkout.*');
                $query->where('ref_id', $refId);
                $result = $query->first();
                if ($result) {
                    $result = $result->toArray();
                } else {
                    $return['message'] = 'Unable to find given reference id.';
                }
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        }
        if (!empty($result)) {
            $return['status'] = true;
            $return['message'] = 'Booking Checkout Details have been fetched successfully';
            $return['data'] = $result;
            return $return;
        } else {
            return $return;
        }
    }

    /**
     * insert new record in database
     */
    public static function createBookingCheckout($bookingPayload) {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            try {
                DB::beginTransaction();
                $bookingDetails = BookingCheckout::create($bookingPayload);
                DB::commit();
                if ($bookingDetails) {
                    $return['status'] = 'true';
                    $return['message'] = 'Booking checkout have created successfully';
                    $return['data'] = $bookingDetails;
                } else {
                    $return['message'] = 'Error during save user record';
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during save user record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }

    public static function updateBookingCheckout($id, $bookingPayload) {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            try {
                DB::beginTransaction();
                $bookingDetails = BookingCheckout::updateOrCreate(['id' => $id], $bookingPayload);
                DB::commit();
                if ($bookingDetails) {
                    $return['status'] = 'true';
                    $return['message'] = 'Booking checkout have updated successfully';
                    $return['data'] = $bookingDetails;
                } else {
                    $return['message'] = 'Error during save user record';
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during save user record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }

    public static function updateBookingByRefId($refId, $bookingPayload) {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            try {
                DB::beginTransaction();
                $bookingDetails = BookingCheckout::updateOrCreate(['ref_id' => $refId], $bookingPayload);
                DB::commit();
                if ($bookingDetails) {
                    $return['status'] = 'true';
                    $return['message'] = 'Booking checkout have updated successfully';
                    $return['data'] = $bookingDetails;
                } else {
                    $return['message'] = 'Error during save user record';
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during save user record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }
}
