<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookingLog extends Model
{
    use HasFactory, Uuids;
    protected $table = 'booking_logs';
    protected $fillable = ['ref_id','booking_type','customer_id', 'email', 'phone_code', 'phone_no', 'status', 'payload','amount','currency', 'booking_details'];
    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }
}
