<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Model;

class CurlRequestLogs extends Model
{
    use Uuids;
    protected $table = 'curl_request_logs';
    protected $fillable = [
        'method',
        'url',
        'headers',
        'request',
        'response',
        'duration_ms',
        'timeout',
    ];



    /**
     * Log cURL request/response in DB.
     *
     * @param string $method
     * @param string $url
     * @param array  $headers
     * @param mixed  $body
     * @param mixed  $response
     * @param float  $duration
     * @param int    $timeout
     * @return \App\Models\CurlRequestLogs
     */
    public static function logRequest(
        $method,
        $url,
        $headers = [],
        $body = null,
        $response = null,
        $duration = 0,
        $timeout = 0
    ) {
        return self::create([
            'method'      => $method,
            'url'         => $url,
            'headers'     => json_encode($headers),
            'request'     => is_string($body) ? $body : json_encode($body),
            'response'    => is_string($response) ? $response : json_encode($response),
            'duration_ms' => round($duration, 2),
            'timeout'     => $timeout,
        ]);
    }
}
