<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Model;

class CustomerLoginToken extends Model
{
    use Uuids;
    protected $fillable = ['customer_id', 'token', 'expires_at', 'used'];

    protected $casts = [
        'expires_at' => 'datetime',
    ];
    public function customer()
    {
        return $this->belongsTo(\App\Models\Customer::class, 'customer_id');
    }

    public function isValid()
    {
        return !$this->used && $this->expires_at->isFuture();
    }
}
