<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EditFlightDetail extends Model
{
    use HasFactory,Uuids;
    protected $table = 'edit_flight_details';
    protected $fillable = ['booking_id', 'ref_id','first_name','last_name','email','booking_date','booking_start_date','customer_details', 'flight_details','complete_flight_details', 'passenger_details', 'processed_price','billing_details','booking_details', 'status'];
    
    public function bookings(){
        return $this->belongsTo(Bookings::class , 'booking_id');
    }
}
