<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FareBasisLog extends Model
{
    use HasFactory, Uuids;
    protected $table = 'fare_basis_logs';
    protected $fillable = [
        'ref_id',
        'request',
        'original_response',
        'formatted_response',
        'search_from'
    ];

    public static function createFareBasisLog(array $fareBasisLog)
    {
        return self::create($fareBasisLog);
    }
}
