<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laravel\Scout\Searchable;

class HotelAddress extends Model
{
    use HasFactory, Searchable;
    protected $connection = 'mysql_static_content';
    protected $table = 'hotel_address';
    protected $guarded = [];

    public $timestamps = false;
    public static function getHotels($config = [])
    {
        $query = HotelAddress::query()->select('hotel_address.*');

        if (!empty($config['where'])) {
            foreach ($config['where'] as $where) {
                $query->where($where[0], $where[1], $where[2]);
            }
        }
        $result = $query->get();

        if ($result) {
            $result = $result->toArray();
        }
        return $result;
    }

    public function hotelName()
    {
        return $this->hasOne(HotelName::class, 'hotel_id', 'hotelid');
    }

    protected function makeAllSearchableUsing($query)
    {
        return $query->with('hotelName');
    }


    public function searchableAs(): string
    {
        return 'hotels';
    }

    public function toSearchableArray(): array
    {
        // Eager load hotel names
        $hotelName = $this->hotelName;

        return [
            'hotel_id'             => $this->hotelid,
            'hotel_name'           => $this->displayname,
            'hotel_name_en' => $this->displayname,
            'hotel_name_ar' => optional($hotelName)->display_name,
            'country_code'         => $this->countrycode,
            'country_name'         => $this->countryname,
            'state'                => $this->state,
            'city_name'            => $this->cityname,
            'address'              => $this->address,
            'zipcode'              => $this->zipcode,
            'star_rating'          => $this->starrating,
            'latitude'             => $this->lat,
            'longitude'            => $this->lng,
            'room_count'           => $this->roomcount,
            'phone'                => $this->phone,
            'fax'                  => $this->fax,
            'email'                => $this->email,
            'website'              => $this->website,
            'property_category'    => $this->propertycategory,
            'property_subcategory' => $this->propertysubcategory,
            'chain_code'           => $this->chaincode,
            'status'               => 'active',
            'sorting'              => 0,
        ];
    }
}
