<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HotelFacility extends Model
{
    protected $connection = 'mysql_static_content';
    protected $table = 'hotel_facilities';
    public $timestamps = false;
    
    protected $fillable = [
        'hotel_id',
        'facility_code',
        'facility_name', 
        'category'
    ];

    /**
     * Get facilities for multiple hotels
     */
    public static function getByHotelIds(array $hotelIds)
    {
        if (empty($hotelIds)) {
            return collect();
        }

        return static::whereIn('hotel_id', $hotelIds)
            ->select(['hotel_id', 'facility_code', 'facility_name', 'category'])
            ->get()
            ->groupBy('hotel_id')
			->toArray();
    }
}