<?php

namespace App\Models;

use App\Models\HotelAddress;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class HotelName extends Model
{
    use HasFactory;
    protected $connection = 'mysql_static_content';
    protected $table = 'hotel_names';

    public static function getHotelsName($config = [])
    {
        $query = HotelName::query()
            ->select('hotel_names.*', 'hotel_address.cityname','hotel_address.countryname','hotel_address.lat', 'hotel_address.lng')
            ->leftJoin('hotel_address', 'hotel_names.hotel_id', '=', 'hotel_address.hotelid');

        if (!empty($config['where'])) {
            foreach ($config['where'] as $where) {
                $query->where($where[0], $where[1], $where[2]);
            }
        }

        $result = $query->get();

        return $result ? $result->toArray() : [];
    }

    public function hotelAddress()
    {
        return $this->belongsTo(HotelAddress::class, 'hotel_id', 'hotelid');
    }
}
