<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HotelRecommendation extends Model
{
    use HasFactory,Uuids;
    protected $fillable = [ 
        'control_id',
        'recommendation_type',
        'destination',
        'hotels',
        'logic_rule',
        'priority_level',
        'effective_date_from',
        'status',
        'notes',
        'created_by'
    ];

    public static function getHotelRecommendation($option = array())
    {
        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = HotelRecommendation::query();
                $query->select('hotel_recommendations.*');
                $query->where('hotel_recommendations.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = HotelRecommendation::query();
                $query->select('hotel_recommendations.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('hotel_recommendations.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif (isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }
        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'Multimedia list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }
    
}
