<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MarkupLog extends Model
{
    use HasFactory, Uuids;
    protected $table = 'markup_logs';
    protected $fillable = [
        'markup_id',
        'service_type_id',
        'action',
        'created_by',
    ];
    public function markup()
    {
        return $this->belongsTo(Markups::class, 'markup_id');
    }
    public function user(){
        return $this->belongsTo(User::class, 'created_by');
    }

}
