<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use App\Models\Bookings;
use App\Traits\Uuids;

class Payment extends Model
{
    use HasFactory, Uuids;
    protected $table = 'payments';
    protected $guarded = [];

    protected $fillable = [
        'merchant_transaction_id', 'payment_id', 'booking_id', 'currency', 'amount', 'booking_cancel_amount', 'refund_amount', 'payment_type', 'payment_brand', 'payment_status', 'payment_flow', 'debit', 'debit_id', 'debit_code', 'debit_description', 'debit_response', 'pre_authorization', 'pre_authorization_id', 'pre_authorization_code', 'pre_authorization_description', 'pre_authorization_response', 'capture', 'capture_id', 'capture_code', 'capture_description', 'capture_response', 'revert', 'revert_id', 'revert_code', 'revert_description', 'revert_response', 'refund_status', 'refund_response', 'refund_at'
    ];

    protected static $logName = 'payments';

    public function getBooking()
    {
        return $this->belongsTo('App\Models\Bookings', 'booking_id');
    }

    /**
     * get list or single or all records to display
     */
    public static function getPayments($option = array())
    {

        $return = array(
            'status' => false,
            'message' => 'something went wrong',
            'data' => []
        );

        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array()
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = Payment::query();
                $query->with(['getBooking']);
                $query->select(
                    'payments.*'
                );
                $query->where('id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                // echo "<pre>";print_r($config);die;
                $query = Payment::query();
                $query->select('payments.*');
                $query->with(['getBooking']);
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('payments.' . $where[0], $where[1], $where[2]);
                    }
                }
                $result = $query->paginate($config['per_page']);
                // echo "<pre>";print_r($result);die;
                $result->setPath('?per_page=' . $config['per_page']);
            } catch (\Exception $e) {
                // echo "<pre>";print_r($e->getMessage());die;
                $return['message'] = $e->getMessage();
            }
        }

        if (!empty($result)) {
            $return['status'] = true;
            $return['message'] = 'Payment list successfully';
            $return['data'] = $result;
            return $return;
        } else {
            return $return;
        }
    }

    /**
     * insert new record in database
     */
    public static function createPayment($paymentData)
    {
        $return = array(
            'status' => false,
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            DB::beginTransaction();
            $paymentDetails = Payment::create($paymentData);
            DB::commit();
            if ($paymentDetails) {

                $return['status'] = true;
                $return['message'] = 'Payment have created successfully';
                $return['data'] = $paymentDetails;
            }
        } catch (\Exception $e) {
            DB::rollBack();
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }

    public static function updatePayment($id, $paymentData)
    {
        $return = array(
            'status' => false,
            'message' => 'something went wrong',
            'data' => []
        );

        try {
            DB::beginTransaction();
            $paymentDetails = Payment::updateOrCreate(['id' => $id], $paymentData);
            DB::commit();
            if ($paymentDetails) {
                $return['status'] = true;
                $return['message'] = 'Payment have updated successfully';
                $return['data'] = $paymentDetails;
            }
        } catch (\Exception $e) {
            DB::rollBack();
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }
}
