<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use App\Traits\Uuids;

class PaymentCheckoutIdLog extends Model
{
    use HasFactory, Uuids;
    protected $table = 'payment_checkout_id_log';
    protected $fillable = ['ref_id', 'booking_id', 'checkout_id', 'payment_brand', 'amount', 'request','response'];

	/**
     * insert new record in database
     */
    public static function createLog($payload) {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => $payload
        );

        try {
            try {
                DB::beginTransaction();
                $log = PaymentCheckoutIdLog::create($payload);
                DB::commit();
                if ($log) {
                    $return['status'] = 'true';
                    $return['message'] = 'Payment Gateway log have created successfully';
                    $return['data'] = $log;
                } else {
                    $return['message'] = 'Error during save user record';
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during save user record : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }

        return $return;
    }
}
