<?php

namespace App\Models;

use App\Enums\ServiceType;
use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalesServiceMarkup extends Model
{
    use Uuids, SoftDeletes;
    protected $table = 'sales_service_markups';
    protected $fillable = [
        'service_name',
        'service_type',
        'cabin_class',
        'markup_percentage',
        'fixed_service_fee',
        'sales_service_type',
        'status',
        'created_by',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public static function getSalesMarkupList($type)
    {
        if ($type == ServiceType::Flight->value) {
            return  SalesServiceMarkup::with('creator')->where('service_name', $type)
                ->latest()
                ->get();
        }
        if ($type == ServiceType::Hotel->value) {
            return SalesServiceMarkup::with('creator')->where('service_name', $type)
                ->latest()
                ->get();
        }
    }
}
