<?php

namespace App\Models;

use App\Traits\HasActivityLogging;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Carbon;
use Intervention\Image\ImageManagerStatic as Image;
use Spatie\Activitylog\Traits\LogsActivity;
use App\Traits\Uuids;
use DateTime;
use DB;
use Illuminate\Support\Facades\Hash;

class SummerOffer extends Model
{
    use HasFactory, LogsActivity, Uuids,HasActivityLogging;

    protected $table = 'summer_offers';

    protected $guarded = [];

    protected static $logName = 'summer_offers';
    protected $fillable = ['offer_title', 'offer_title_ar', 'offer_content', 'offer_content_ar', 'offer_link', 'offer_image', 'status'];

    /**
     * ger list or single or all records to display
     */
    public static function getSummerOffers($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false,
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = SummerOffer::query();
                $query->select('summer_offers.*');
                $query->where('summer_offers.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = SummerOffer::query();
                $query->select('summer_offers.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('summer_offers.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif (isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }

        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'Summer Offer list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createSummerOffer($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $summerOfferArrayData = array(
            'offer_title' => $requestData['offer_title'],
            'offer_title_ar' => $requestData['offer_title_ar'],
            'offer_content' => $requestData['offer_content'],
            'offer_content_ar' => $requestData['offer_content_ar'],
            'offer_link' => $requestData['offer_link'],
            'offer_image' => $requestData['offer_image'],
            'status' => $requestData['status'],
        );
        if (strpos(request()->path(), 'api') === false && isset($requestData['offer_image'])) {
            //upload image
            try {
                $destinationPath = storage_path() . '/app/public/summer-offers/';
                if (!is_dir($destinationPath)) {
                    mkdir($destinationPath, 0777);
                }

                $file = $requestData['offer_image'];
                $image_resize = Image::make($requestData['offer_image']);
                $image_resize->resize(300, 300);
                $fileName =  uniqid() . time() . '.' . $requestData['offer_image']->extension();
                $image_resize->save($destinationPath . $fileName);
                $url = URL::to('/storage/') . '/summer-offers/' . $fileName;
                $summerOfferArrayData['offer_image'] = $url;
            } catch (Exception $e) {
                $return['message'] = 'Error during save image banner :' . $e->getMessage();
            }
        }
        try {
            DB::beginTransaction();
            $summerOfferData = SummerOffer::create($summerOfferArrayData);
            DB::commit();
            if ($summerOfferData) {
                $return['status'] = 1;
                $return['message'] = 'Summer Offer "'. $requestData['offer_title'] . '" have saved successfully';
                $return['data'] = $summerOfferData;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save Summer Offers : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateSummerOffer($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {

            @$summerOfferDetails = array(
                'id' => $requestData['id'],
                'offer_title' => $requestData['offer_title'],
                'offer_title_ar' => $requestData['offer_title_ar'],
                'offer_content' => $requestData['offer_content'],
                'offer_content_ar' => $requestData['offer_content_ar'],
                'offer_link' => $requestData['offer_link'],
                'offer_image' => $requestData['offer_image'],
                'status' => $requestData['status'],
            );
            if (strpos(request()->path(), 'api') === false && isset($requestData['offer_image'])) {
                try {
                    $destinationPath = storage_path() . '/app/public/summer-offers/';
                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777);
                    }

                    $file = $requestData['offer_image'];
                    $image_resize = Image::make($requestData['offer_image']);
                    $image_resize->resize(300, 300);
                    $fileName =  uniqid() . time() . '.' . $requestData['offer_image']->extension();
                    $image_resize->save($destinationPath . $fileName);
                    $url = URL::to('/storage/') . '/summer-offers/' . $fileName;
                    $summerOfferDetails['offer_image'] = $url;

                    if ($requestData['saved_offer_image'] != '') {
                        $savedOfferImageArr = explode('/summer-offers/', $requestData['saved_offer_image']);
                        $fileName = $destinationPath.$savedOfferImageArr[1];
                        File::delete($fileName);
                    }
                } catch (Exception $e) {
                    $return['message'] = 'Error during update Summer Offers :' . $e->getMessage();
                }
            } elseif (strpos(request()->path(), 'api') === false && $requestData['saved_offer_image'] != '') {
                $requestData['offer_image'] = $requestData['saved_offer_image'];
            }
            try {

                DB::beginTransaction();
                $matchSummerOfferType = ['id' => $summerOfferDetails['id']];
                $SummerOfferType = SummerOffer::updateOrCreate($matchSummerOfferType, $summerOfferDetails);
                DB::commit();
                if ($SummerOfferType) {
                    $return['status'] = 1;
                    $return['message'] = 'Summer Offer "'. $requestData['offer_title'] . '" have updated successfully';
                    $return['data'] = $SummerOfferType;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during update Summer Offers : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteSummerOffer($summerOfferId)
    {
        $summerOfferDetails = SummerOffer::where('id', $summerOfferId)->first()->toArray();
        if ($summerOfferDetails) {
            SummerOffer::where('id', $summerOfferId)->delete();

            if ($summerOfferDetails['offer_image'] != '') {
                $savedOfferImageArr = explode('/summer-offers/', $summerOfferDetails['offer_image']);
                $destinationPath = storage_path() . '/app/public/summer-offers/';
                $fileName = $destinationPath.$savedOfferImageArr[1];
                File::delete($fileName);
            }

            $return['status'] = 1;
            $return['message'] = 'Summer Offer "' . $summerOfferDetails['offer_title'] . '" have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete summer offer. Please try again.';
        }

        return $return;
    }
}
