<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuids;
use DB;

class SupplierLog extends Model
{
    use HasFactory, Uuids;

    protected $table = 'supplier_log';

    protected $guarded = [];

    protected static $logName = 'supplier_log';
    protected $fillable = ['log_id', 'log_parent_id', 'type', 'supplier', 'supplier_reference', 'ama_client_ref', 'log_type', 'customer_id', 'booking_id', 'request', 'response'];

    /**
     * ger list or single or all records to display
     */
    public static function getSupplierLogs($where = array()) {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            $query = SupplierLog::query();
            $query->select('supplier_log.*');
            $query->orderBy('created_at', 'DESC');

            if (count($where) > 0) {
                foreach ($where as $value) {
                    $query->where('supplier_log.' . $value[0], $value[1], $value[2]);
                }
            }
            $result = $query->get();
            if ($result) {
                $result = $result->toArray();
            }

            $return['status'] = 'true';
            $return['message'] = 'Supplier log have fetched successfully';
            $return['data'] = $result;
            return $return;
        } catch (\Exception $e) {
            $return['message'] = $e->getMessage();
        }
        return $return;
    }

    public static function createSupplierLog($requestData) {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            DB::beginTransaction();
            $supplierLog = SupplierLog::create($requestData);
            DB::commit();
            if ($supplierLog) {
                $return['status'] = 'true';
                $return['message'] = 'Supplier log have created successfully';
                $return['data'] = $supplierLog;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save supplier log: ' . $e->getMessage();
        }

        return $return;
    }

    public static function updateSupplierLog($requestData) {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            $condition = ['id' => $requestData['id']];
            DB::beginTransaction();
            $supplierLog = SupplierLog::updateOrCreate($condition, $requestData);
            DB::commit();
            if ($supplierLog) {
                $return['status'] = 'true';
                $return['message'] = 'Supplier log have updated successfully';
                $return['data'] = $supplierLog;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during update supplier log: ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteSupplierLog($logId) {
        $return = [];
        $supplierLog = SupplierLog::where('id', $logId)->first()->toArray();
        if ($supplierLog) {
            SupplierLog::where('id', $logId)->delete();
            $return['status'] = 1;
            $return['message'] = 'Supplier log have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete Supplier log. Please try again.';
        }
        return $return;
    }
}
