<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TopDestination extends Model
{
    use HasFactory,Uuids;
    protected $fillable = [
        'country_code',
        'country_name',
        'country_name_arabic',
        'status',
    ];

    public function i18ns()
    {
        return $this->hasMany(TopDestinationI18s::class,'top_destination_id','id');
    }
    
}
