<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TopDestinationI18s extends Model
{
    use HasFactory,Uuids;
    protected $fillable = [
        'top_destination_id',
        'city_code',
        'city_name',
        'city_name_arabic',
        'thumbnail',
    ];

    public function topDestination()
    {
        return $this->belongsTo(TopDestination::class,'top_destination_id','id');
    }
}
