<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuids;
use DB;

class TraacsLog extends Model
{
    use HasFactory, Uuids;

    protected $table = 'traacs_log';

    protected $guarded = [];

    protected static $logName = 'traacs_log';
    protected $fillable = ['booking_id', 'traacs_no', 'traacs_booking_id', 'log_type', 'supplier_code', 'request_payload', 'status', 'message'];

    /**
     * ger list or single or all records to display
     */
    public static function getTraacsLog($where = array()) {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            $query = TraacsLog::query();
            $query->select('traacs_log.*');
            $query->orderBy('created_at', 'DESC');

            if (count($where) > 0) {
                foreach ($where as $value) {
                    $query->where('traacs_log.' . $value[0], $value[1], $value[2]);
                }
            }
            $result = $query->get();
            if ($result) {
                $result = $result->toArray();
            }

            $return['status'] = 'true';
            $return['message'] = 'Traacs log have fetched successfully';
            $return['data'] = $result;
            return $return;
        } catch (\Exception $e) {
            $return['message'] = $e->getMessage();
        }
        return $return;
    }

    public static function createTraacsLog($requestData) {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            DB::beginTransaction();
            $supplierLog = TraacsLog::create($requestData);
            DB::commit();
            if ($supplierLog) {
                $return['status'] = 'true';
                $return['message'] = 'Traacs log have created successfully';
                $return['data'] = $supplierLog;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save supplier log: ' . $e->getMessage();
        }

        return $return;
    }

    public static function updateTraacsLog($requestData) {
        $return = array(
            'status' => 'false',
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            $condition = ['id' => $requestData['id']];
            DB::beginTransaction();
            $supplierLog = TraacsLog::updateOrCreate($condition, $requestData);
            DB::commit();
            if ($supplierLog) {
                $return['status'] = 'true';
                $return['message'] = 'Traacs log have updated successfully';
                $return['data'] = $supplierLog;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during update supplier log: ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteTraacsLog($logId) {
        $return = [];
        $supplierLog = TraacsLog::where('id', $logId)->first()->toArray();
        if ($supplierLog) {
            TraacsLog::where('id', $logId)->delete();
            $return['status'] = 1;
            $return['message'] = 'Traacs log have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete Traacs log. Please try again.';
        }
        return $return;
    }
}
